/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.control;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.whitepages.model.Card;
import org.silverpeas.components.whitepages.record.UserRecord;
import org.silverpeas.components.whitepages.record.UserTemplate;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.i18n.AbstractBean;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public final class CardHeader
extends AbstractBean
implements LocalizedContribution,
Identifiable,
Comparable<CardHeader> {
    private static final long serialVersionUID = -8781512864589764317L;
    private long id;
    private String instanceId;
    private final String date;
    private final String creatorId;
    private static final SettingBundle whitePagesIcons = ResourceLocator.getSettingBundle((String)"org.silverpeas.whitePages.settings.whitePagesIcons");
    static Map<String, UserTemplate> templates = new HashMap<String, UserTemplate>();

    public void init(long id, Card card) {
        String label;
        this.id = id;
        try {
            UserRecord user = CardHeader.getUserRecord(card);
            if (user == null) {
                label = "user(" + id + ")";
            } else {
                Field firstName = user.getField("FirstName");
                Field name = user.getField("LastName");
                label = name.getValue("") + " " + firstName.getValue("");
                String isMailHidden = CardHeader.getParam("isEmailHidden", this.instanceId);
                if (isMailHidden != null && isMailHidden.equals("yes")) {
                    this.setDescription(this.buildMailLink(this.instanceId, card.getPK().getId()));
                } else {
                    this.setDescription(user.getField("Mail").getValue(""));
                }
            }
        }
        catch (FormException e) {
            label = "user(" + id + ")";
        }
        this.setName(label);
        this.instanceId = card.getInstanceId();
    }

    private String buildMailLink(String instanceId, String cardId) {
        return "<a href=\"" + URLUtil.getApplicationURL() + URLUtil.getURL(null, (String)instanceId) + "NotifyExpert?cardId=" + cardId + "\"><img src=\"" + URLUtil.getApplicationURL() + whitePagesIcons.getString("whitePages.notify") + "\" border=\"0\"></a>";
    }

    public CardHeader(long id, Card card, String instanceId, String date, String creatorId) {
        this.instanceId = instanceId;
        this.date = date;
        this.creatorId = creatorId;
        this.init(id, card);
    }

    public String getURL() {
        return "consultIdentity?userCardId=" + this.id;
    }

    private static UserRecord getUserRecord(Card card) {
        try {
            UserTemplate templateUser = CardHeader.getUserTemplate(card.getInstanceId());
            card.writeUserRecord(templateUser.getRecord(card.getUserId()));
            return card.readUserRecord();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static UserTemplate getUserTemplate(String instanceId) {
        UserTemplate template = templates.get(instanceId);
        if (template == null) {
            SettingBundle templateSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.whitePages.settings.template");
            String templateDir = templateSettings.getString("templateDir");
            String userTemplate = CardHeader.getParam("userTemplate", instanceId);
            template = new UserTemplate(templateDir.replace('\\', '/') + "/" + userTemplate.replace('\\', '/'), "");
            templates.put(instanceId, template);
        }
        return template;
    }

    private static String getParam(String paramName, String instanceId) {
        return AdministrationServiceProvider.getAdminService().getComponentParameterValue(instanceId, paramName);
    }

    public String getId() {
        return String.valueOf(this.id);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getId(), (String)this.getContributionType());
    }

    public String getTitle() {
        return this.getName();
    }

    public String getContributionType() {
        return "BusinessCard";
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Date getCreationDate() {
        if (StringUtil.isDefined((String)this.date)) {
            try {
                return DateUtil.parseDate((String)this.date);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    @Override
    public int compareTo(CardHeader other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CardHeader)) {
            return false;
        }
        CardHeader that = (CardHeader)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).toHashCode();
    }
}

