/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.projectmanager.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.components.projectmanager.model.TaskDetail;
import org.silverpeas.kernel.util.StringUtil;

public class Filtre
implements Serializable {
    private static final long serialVersionUID = -5172014425250531057L;
    private static final String FROM_ACTION = "FROM_ACTION";
    private static final String TO_ACTION = "TO_ACTION";
    private static final String PROJECT_CODE = "PROJECT_CODE";
    private static final String PROJECT_DESCRIPTION = "PROJECT_DESCRIPTION";
    private static final String ACTION_NAME = "ACTION_NAME";
    private static final String STATUS = "STATUS";
    private static final String FROM_START_DATE = "FROM_START_DATE";
    private static final String TO_START_DATE = "TO_START_DATE";
    private static final String FROM_END_DATE = "FROM_END_DATE";
    private static final String TO_END_DATE = "TO_END_DATE";
    private static final String WITH_DELAY = "WITH_DELAY";
    private static final String WITHOUT_DELAY = "WITHOUT_DELAY";
    private static final String ENDED = "ENDED";
    private static final String NOT_ENDED = "NOT_ENDED";
    private static final String TASK_MANAGER = "TASK_MANAGER";
    private String actionFrom = null;
    private String actionTo = null;
    private String codeProjet = null;
    private String descProjet = null;
    private String actionNom = null;
    private String statut = null;
    private Date datePVFrom = null;
    private Date datePVTo = null;
    private Date dateDebutFrom = null;
    private Date dateDebutTo = null;
    private Date dateFinFrom = null;
    private Date dateFinTo = null;
    private String datePVFromUI = null;
    private String datePVToUI = null;
    private String dateDebutFromUI = null;
    private String dateDebutToUI = null;
    private String dateFinFromUI = null;
    private String dateFinToUI = null;
    private String retard = null;
    private String avancement = null;
    private String responsableId = null;
    private String responsableName = null;
    private String visibleMOA = null;
    private static final Map<String, BiPredicate<Filtre, TaskDetail>> MATCHING_PREDICATES = Map.ofEntries(Map.entry("FROM_ACTION", (f, t) -> t.getChrono() >= Integer.parseInt(f.getActionFrom())), Map.entry("TO_ACTION", (f, t) -> t.getChrono() <= Integer.parseInt(f.getActionTo())), Map.entry("PROJECT_CODE", (f, t) -> f.getCodeProjet().equals(t.getCodeProjet())), Map.entry("PROJECT_DESCRIPTION", (f, t) -> StringUtil.likeIgnoreCase((String)t.getDescriptionProjet(), (String)("%" + f.getDescProjet() + "%"))), Map.entry("ACTION_NAME", (f, t) -> StringUtil.likeIgnoreCase((String)t.getNom(), (String)("%" + f.getActionNom() + "%"))), Map.entry("STATUS", (f, t) -> Integer.parseInt(f.getStatut()) == t.getStatut()), Map.entry("FROM_START_DATE", (f, t) -> t.getDateDebut().compareTo(f.getDateDebutFrom()) >= 0), Map.entry("TO_START_DATE", (f, t) -> t.getDateDebut().compareTo(f.getDateDebutTo()) <= 0), Map.entry("FROM_END_DATE", (f, t) -> t.getDateFin().compareTo(f.getDateFinFrom()) >= 0), Map.entry("TO_END_DATE", (f, t) -> t.getDateFin().compareTo(f.getDateFinTo()) <= 0), Map.entry("WITH_DELAY", (f, t) -> t.getDateFin().compareTo(new Date()) < 0 && t.getAvancement() == 100), Map.entry("WITHOUT_DELAY", (f, t) -> t.getDateFin().compareTo(new Date()) >= 0 && t.getAvancement() == 100), Map.entry("ENDED", (f, t) -> t.getAvancement() == 100), Map.entry("NOT_ENDED", (f, t) -> t.getAvancement() < 100), Map.entry("TASK_MANAGER", (f, t) -> Integer.parseInt(f.getResponsableId()) == t.getResponsableId()));

    public String getActionFrom() {
        return this.actionFrom;
    }

    public String getActionNom() {
        return this.actionNom;
    }

    public String getActionTo() {
        return this.actionTo;
    }

    public String getAvancement() {
        return this.avancement;
    }

    public String getCodeProjet() {
        return this.codeProjet;
    }

    public Date getDateDebutFrom() {
        return this.dateDebutFrom;
    }

    public Date getDateDebutTo() {
        return this.dateDebutTo;
    }

    public Date getDateFinFrom() {
        return this.dateFinFrom;
    }

    public Date getDateFinTo() {
        return this.dateFinTo;
    }

    public Date getDatePVFrom() {
        return this.datePVFrom;
    }

    public Date getDatePVTo() {
        return this.datePVTo;
    }

    public String getDescProjet() {
        return this.descProjet;
    }

    public String getResponsableId() {
        return this.responsableId;
    }

    public String getRetard() {
        return this.retard;
    }

    public String getStatut() {
        return this.statut;
    }

    public String getVisibleMOA() {
        return this.visibleMOA;
    }

    public void setActionFrom(String string) {
        this.actionFrom = string;
    }

    public void setActionNom(String string) {
        this.actionNom = string;
    }

    public void setActionTo(String string) {
        this.actionTo = string;
    }

    public void setAvancement(String string) {
        this.avancement = string;
    }

    public void setCodeProjet(String string) {
        this.codeProjet = string;
    }

    public void setDateDebutFrom(Date date) {
        this.dateDebutFrom = date;
    }

    public void setDateDebutTo(Date date) {
        this.dateDebutTo = date;
    }

    public void setDateFinFrom(Date date) {
        this.dateFinFrom = date;
    }

    public void setDateFinTo(Date date) {
        this.dateFinTo = date;
    }

    public void setDatePVFrom(Date date) {
        this.datePVFrom = date;
    }

    public void setDatePVTo(Date date) {
        this.datePVTo = date;
    }

    public void setDescProjet(String string) {
        this.descProjet = string;
    }

    public void setResponsableId(String string) {
        this.responsableId = string;
    }

    public void setRetard(String string) {
        this.retard = string;
    }

    public void setStatut(String string) {
        this.statut = string;
    }

    public void setVisibleMOA(String string) {
        this.visibleMOA = string;
    }

    public String getDateDebutFromUI() {
        return this.dateDebutFromUI;
    }

    public String getDateDebutToUI() {
        return this.dateDebutToUI;
    }

    public String getDateFinFromUI() {
        return this.dateFinFromUI;
    }

    public String getDateFinToUI() {
        return this.dateFinToUI;
    }

    public String getDatePVFromUI() {
        return this.datePVFromUI;
    }

    public String getDatePVToUI() {
        return this.datePVToUI;
    }

    public void setDateDebutFromUI(String string) {
        this.dateDebutFromUI = string;
    }

    public void setDateDebutToUI(String string) {
        this.dateDebutToUI = string;
    }

    public void setDateFinFromUI(String string) {
        this.dateFinFromUI = string;
    }

    public void setDateFinToUI(String string) {
        this.dateFinToUI = string;
    }

    public void setDatePVFromUI(String string) {
        this.datePVFromUI = string;
    }

    public void setDatePVToUI(String string) {
        this.datePVToUI = string;
    }

    public String getResponsableName() {
        return this.responsableName;
    }

    public void setResponsableName(String string) {
        this.responsableName = string;
    }

    public boolean matches(TaskDetail task) {
        ArrayList<String> predicates = new ArrayList<String>();
        this.addFromStringFilter(predicates, this.getActionFrom(), FROM_ACTION);
        this.addFromStringFilter(predicates, this.getActionTo(), TO_ACTION);
        this.addFromStringFilter(predicates, this.getCodeProjet(), PROJECT_CODE);
        this.addFromStringFilter(predicates, this.getDescProjet(), PROJECT_DESCRIPTION);
        this.addFromStringFilter(predicates, this.getActionNom(), ACTION_NAME);
        this.addFromIntegerFilter(predicates, this.getStatut(), STATUS);
        if (this.getDateDebutFrom() != null) {
            predicates.add(FROM_START_DATE);
        }
        if (this.getDateDebutTo() != null) {
            predicates.add(TO_START_DATE);
        }
        if (this.getDateFinFrom() != null) {
            predicates.add(FROM_END_DATE);
        }
        if (this.getDateFinTo() != null) {
            predicates.add(TO_END_DATE);
        }
        if (this.getRetard() != null && !"-1".equals(this.getRetard())) {
            if ("1".equals(this.getRetard())) {
                predicates.add(WITH_DELAY);
            } else {
                predicates.add(WITHOUT_DELAY);
            }
        }
        if (this.getAvancement() != null && !"-1".equals(this.getAvancement())) {
            if ("1".equals(this.getAvancement())) {
                predicates.add(ENDED);
            } else {
                predicates.add(NOT_ENDED);
            }
        }
        this.addFromStringFilter(predicates, this.getResponsableId(), TASK_MANAGER);
        return predicates.stream().map(MATCHING_PREDICATES::get).noneMatch(p -> !p.test(this, task));
    }

    private void addFromStringFilter(List<String> predicates, String filter, String predicateKey) {
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            predicates.add(predicateKey);
        }
    }

    private void addFromIntegerFilter(List<String> predicates, String filter, String predicateKey) {
        if (StringUtils.isNotEmpty((CharSequence)filter) && !"-1".equals(filter)) {
            predicates.add(predicateKey);
        }
    }
}

