/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningQuery;
import org.silverpeas.components.datawarning.model.DataWarningQueryResult;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarningResult {
    private boolean triggerRequired = false;
    private long trigger = 0L;
    private int triggerCondition = 0;
    private long triggerActualValue = 0L;
    private boolean triggerEnabled = false;
    private DataWarningQuery triggerQuery = null;
    private DataWarningQueryResult triggerResult = null;
    private DataWarningQuery dataQuery = null;
    private DataWarningQueryResult queryResult = null;

    public DataWarningResult(boolean tr) {
        this.triggerRequired = tr;
        this.triggerEnabled = !tr;
    }

    public boolean hasError() {
        if (this.queryResult != null) {
            return this.queryResult.hasError();
        }
        return false;
    }

    public void setTriggerQuery(DataWarningQuery dwq) {
        this.triggerQuery = dwq;
        this.setTrigger(this.triggerQuery.getTheTrigger());
        this.setTriggerCondition(this.triggerQuery.getTheTriggerCondition());
    }

    public DataWarningQuery getTriggerQuery() {
        return this.triggerQuery;
    }

    public long getTrigger() {
        return this.trigger;
    }

    public void setTrigger(long t) {
        this.trigger = t;
    }

    public int getTriggerCondition() {
        return this.triggerCondition;
    }

    public void setTriggerCondition(int tc) {
        this.triggerCondition = tc;
    }

    public long getTriggerActualValue() {
        return this.triggerActualValue;
    }

    public long getTriggerActualValue(String userId) {
        if (this.triggerResult.isPersoEnabled()) {
            try {
                return this.triggerResult.returnTriggerValueFromResult(userId);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
                return 0L;
            }
        }
        return this.getTriggerActualValue();
    }

    public void setTriggerActualValue(long tav) {
        this.triggerActualValue = tav;
    }

    public boolean getTriggerEnabled() {
        return this.triggerEnabled;
    }

    public boolean getTriggerEnabled(String userId) {
        if (this.triggerResult.isPersoEnabled()) {
            if (this.triggerResult.getNbRows(userId) > 0) {
                try {
                    if (this.getQueryResult().isPersoEnabled()) {
                        return this.triggerQuery.checkTriggerSatisfied(this.triggerResult.returnTriggerValueFromResult(userId));
                    }
                    return this.triggerQuery.checkTriggerSatisfied(this.triggerResult.returnTriggerValueFromResult());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return this.getTriggerEnabled();
    }

    public void setTriggerEnabled(boolean te) {
        this.triggerEnabled = te;
    }

    public boolean getTriggerRequired() {
        return this.triggerRequired;
    }

    public DataWarningQueryResult getTriggerResult() {
        return this.triggerResult;
    }

    public void computeTriggerResult(DataWarning dataWarning) {
        this.triggerResult = this.triggerQuery.executeQuery(dataWarning);
        if (!this.triggerResult.hasError()) {
            try {
                this.setTriggerActualValue(this.triggerResult.returnTriggerValueFromResult());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
                this.triggerResult.addError(e, "Value = " + this.triggerResult.getValue(0, 0));
            }
        }
        if (!this.triggerResult.hasError()) {
            this.setTriggerEnabled(this.triggerQuery.checkTriggerSatisfied(this.getTriggerActualValue()));
        } else {
            this.setTriggerEnabled(false);
        }
    }

    public void setDataQuery(DataWarningQuery dwq) {
        this.dataQuery = dwq;
    }

    public DataWarningQuery getDataQuery() {
        return this.dataQuery;
    }

    public DataWarningQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(DataWarningQueryResult dwqr) {
        this.queryResult = dwqr;
    }

    public String getConditionDisplayedString(SettingBundle rl) {
        String valret;
        switch (this.getTriggerCondition()) {
            case 0: {
                valret = rl.getString("triggerCondition0");
                break;
            }
            case 1: {
                valret = rl.getString("triggerCondition1");
                break;
            }
            case 2: {
                valret = rl.getString("triggerCondition2");
                break;
            }
            case 3: {
                valret = rl.getString("triggerCondition3");
                break;
            }
            case 4: {
                valret = rl.getString("triggerCondition4");
                break;
            }
            case 5: {
                valret = rl.getString("triggerCondition5");
                break;
            }
            default: {
                valret = "";
            }
        }
        return valret;
    }
}

