/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PermissionEntryCache {
    private static final Logger log = LoggerFactory.getLogger(PermissionEntryCache.class);
    private final Map<String, PrincipalPermissionEntries> entries = new HashMap<String, PrincipalPermissionEntries>();

    PermissionEntryCache() {
    }

    @NotNull
    PrincipalPermissionEntries getFullyLoadedEntries(@NotNull PermissionStore store, @NotNull String principalName) {
        PrincipalPermissionEntries ppe = this.entries.get(principalName);
        if (ppe == null || !ppe.isFullyLoaded()) {
            ppe = store.load(principalName);
            this.entries.put(principalName, ppe);
        }
        return ppe;
    }

    void init(@NotNull String principalName, long expectedSize) {
        if (!this.entries.containsKey(principalName)) {
            this.entries.put(principalName, new PrincipalPermissionEntries(expectedSize));
        }
    }

    void load(@NotNull PermissionStore store, @NotNull Collection<PermissionEntry> ret, @NotNull String principalName, @NotNull String path) {
        if (this.entries.containsKey(principalName)) {
            PrincipalPermissionEntries ppe = this.entries.get(principalName);
            Collection<PermissionEntry> pes = ppe.getEntriesByPath(path);
            if (ppe.isFullyLoaded() || pes != null) {
                if (pes != null) {
                    ret.addAll(pes);
                }
            } else {
                pes = store.load(principalName, path);
                if (pes == null) {
                    ppe.rememberNotAccessControlled(path);
                } else {
                    ppe.putEntriesByPath(path, pes);
                    ret.addAll(pes);
                }
            }
        } else {
            log.error("Failed to load entries for principal '{}' at path {}", (Object)principalName, (Object)path);
        }
    }
}

