/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupRestoreImpl;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.segment.DefaultSegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.LoggingHook;
import org.apache.jackrabbit.oak.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.segment.SegmentCheckpointMBean;
import org.apache.jackrabbit.oak.segment.SegmentDiscoveryLiteDescriptors;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGC;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGCMBean;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.FileStoreGCMonitor;
import org.apache.jackrabbit.oak.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.MetricsIOMonitor;
import org.apache.jackrabbit.oak.segment.file.MetricsRemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.CachingPersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitPersistence;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.cluster.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.apache.jackrabbit.oak.spi.descriptors.GenericDescriptors;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentNodeStoreRegistrar {
    private final Configuration cfg;

    static SegmentNodeStore registerSegmentNodeStore(Configuration cfg) throws IOException {
        return new SegmentNodeStoreRegistrar(cfg).register();
    }

    private SegmentNodeStoreRegistrar(Configuration cfg) {
        this.cfg = cfg;
    }

    private SegmentNodeStore register() throws IOException {
        CacheStatsMBean nodeDeduplicationCacheStats;
        CacheStatsMBean templateDeduplicationCacheStats;
        FileStore store;
        if (this.cfg.getBlobStore() == null && (this.cfg.hasCustomBlobStore() || this.cfg.isSecondarySegmentStore())) {
            this.cfg.getLogger().info("BlobStore enabled. SegmentNodeStore will be initialized once the blob store becomes available");
            return null;
        }
        if (this.cfg.getSegmentNodeStorePersistence() == null && this.cfg.hasCustomSegmentStore()) {
            this.cfg.getLogger().info("customSegmentStore enabled. SegmentNodeStore will be initialized once the custom segment store becomes available");
            return null;
        }
        GCMonitor gcMonitor = GCMonitor.EMPTY;
        if (this.cfg.isPrimarySegmentStore()) {
            GCMonitorTracker tracker = new GCMonitorTracker();
            tracker.start(this.cfg.getWhiteboard());
            this.registerCloseable((AbstractServiceTracker<?>)tracker);
            gcMonitor = tracker;
        }
        if (this.cfg.getRetainedGenerations() != this.cfg.getDefaultRetainedGenerations()) {
            this.cfg.getLogger().warn("The number of retained generations defaults to {} and can't be changed. This configuration option is considered deprecated and will be removed in the future.", (Object)2);
        }
        SegmentGCOptions gcOptions = new SegmentGCOptions(this.cfg.getPauseCompaction(), this.cfg.getRetryCount(), this.cfg.getForceCompactionTimeout()).setGcSizeDeltaEstimation(this.cfg.getSizeDeltaEstimation()).setMemoryThreshold(this.cfg.getMemoryThreshold()).setEstimationDisabled(this.cfg.getDisableEstimation()).setGCLogInterval(this.cfg.getGCProcessLog());
        if (this.cfg.isStandbyInstance()) {
            gcOptions.setRetainedGenerations(1);
        }
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(this.cfg.getSegmentDirectory()).withSegmentCacheSize(this.cfg.getSegmentCacheSize()).withStringCacheSize(this.cfg.getStringCacheSize()).withTemplateCacheSize(this.cfg.getTemplateCacheSize()).withStringDeduplicationCacheSize(this.cfg.getStringDeduplicationCacheSize()).withTemplateDeduplicationCacheSize(this.cfg.getTemplateDeduplicationCacheSize()).withNodeDeduplicationCacheSize(this.cfg.getNodeDeduplicationCacheSize()).withMaxFileSize(this.cfg.getMaxFileSize()).withMemoryMapping(this.cfg.getMemoryMapping()).withGCMonitor(gcMonitor).withIOMonitor(new MetricsIOMonitor(this.cfg.getStatisticsProvider())).withRemoteStoreMonitor(new MetricsRemoteStoreMonitor(this.cfg.getStatisticsProvider())).withStatisticsProvider(this.cfg.getStatisticsProvider()).withGCOptions(gcOptions);
        if (this.cfg.hasCustomBlobStore() && this.cfg.getBlobStore() != null) {
            this.cfg.getLogger().info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)this.cfg.getBlobStore());
            builder.withBlobStore(this.cfg.getBlobStore());
        }
        if (this.cfg.hasCustomSegmentStore() && this.cfg.getSegmentNodeStorePersistence() != null) {
            SegmentNodeStorePersistence customPersistence = this.cfg.getSegmentNodeStorePersistence();
            if (this.cfg.hasCachePersistence()) {
                this.cfg.getLogger().info("Using persistent cache for the custom persistence [{}]", (Object)customPersistence);
                customPersistence = new CachingPersistence(this.cfg.getPersistentCache(), customPersistence);
            }
            if (this.cfg.hasSplitPersistence()) {
                this.cfg.getLogger().info("Initializing SegmentNodeStore with custom persistence [{}] and local writes", (Object)customPersistence);
                this.cfg.getSplitPersistenceDirectory().mkdirs();
                TarPersistence rwPersistence = new TarPersistence(this.cfg.getSplitPersistenceDirectory());
                SplitPersistence persistence = new SplitPersistence(customPersistence, rwPersistence);
                builder.withCustomPersistence(persistence);
            } else {
                this.cfg.getLogger().info("Initializing SegmentNodeStore with custom persistence [{}]", (Object)customPersistence);
                builder.withCustomPersistence(customPersistence);
            }
        }
        if (this.cfg.isStandbyInstance()) {
            builder.withSnfeListener(SegmentNotFoundExceptionListener.IGNORE_SNFE);
            builder.withEagerSegmentCaching(true);
        }
        try {
            store = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            this.cfg.getLogger().error("The storage format is not compatible with this version of Oak Segment Tar", (Throwable)e);
            return null;
        }
        this.registerCloseable(store);
        WhiteboardExecutor executor = new WhiteboardExecutor();
        executor.start(this.cfg.getWhiteboard());
        this.registerCloseable((AbstractServiceTracker<?>)executor);
        CacheStatsMBean segmentCacheStats = store.getSegmentCacheStats();
        this.registerCloseable(this.registerMBean(CacheStatsMBean.class, segmentCacheStats, "CacheStats", segmentCacheStats.getName()));
        CacheStatsMBean stringCacheStats = store.getStringCacheStats();
        this.registerCloseable(this.registerMBean(CacheStatsMBean.class, stringCacheStats, "CacheStats", stringCacheStats.getName()));
        CacheStatsMBean templateCacheStats = store.getTemplateCacheStats();
        this.registerCloseable(this.registerMBean(CacheStatsMBean.class, templateCacheStats, "CacheStats", templateCacheStats.getName()));
        WriterCacheManager cacheManager = builder.getCacheManager();
        CacheStatsMBean stringDeduplicationCacheStats = cacheManager.getStringCacheStats();
        if (stringDeduplicationCacheStats != null) {
            this.registerCloseable(this.registerMBean(CacheStatsMBean.class, stringDeduplicationCacheStats, "CacheStats", stringDeduplicationCacheStats.getName()));
        }
        if ((templateDeduplicationCacheStats = cacheManager.getTemplateCacheStats()) != null) {
            this.registerCloseable(this.registerMBean(CacheStatsMBean.class, templateDeduplicationCacheStats, "CacheStats", templateDeduplicationCacheStats.getName()));
        }
        if ((nodeDeduplicationCacheStats = cacheManager.getNodeCacheStats()) != null) {
            this.registerCloseable(this.registerMBean(CacheStatsMBean.class, nodeDeduplicationCacheStats, "CacheStats", nodeDeduplicationCacheStats.getName()));
        }
        FileStoreGCMonitor monitor = new FileStoreGCMonitor(Clock.SIMPLE);
        this.registerCloseable(this.register(GCMonitor.class, monitor));
        if (!this.cfg.isStandbyInstance()) {
            this.registerCloseable(this.registerMBean(SegmentRevisionGC.class, new SegmentRevisionGCMBean(store, gcOptions, monitor), "SegmentRevisionGarbageCollection", "Segment node store revision garbage collection"));
        }
        this.registerCloseable(this.registerMBean(RevisionGCMBean.class, new RevisionGC(store.getGCRunner(), store::cancelGC, monitor::getStatus, (Executor)executor), "RevisionGarbageCollection", "Revision garbage collection"));
        this.registerCloseable(this.registerMBean(FileStoreStatsMBean.class, store.getStats(), "FileStoreStats", "FileStore statistics"));
        SegmentNodeStore.SegmentNodeStoreBuilder segmentNodeStoreBuilder = SegmentNodeStoreBuilders.builder(store).withStatisticsProvider(this.cfg.getStatisticsProvider());
        segmentNodeStoreBuilder.dispatchChanges(this.cfg.dispatchChanges());
        Logger log = LoggerFactory.getLogger((String)(LoggingHook.class.getName() + ".writer"));
        if (log.isTraceEnabled()) {
            segmentNodeStoreBuilder.withLoggingHook(arg_0 -> ((Logger)log).trace(arg_0));
        }
        SegmentNodeStore segmentNodeStore = segmentNodeStoreBuilder.build();
        if (this.cfg.isPrimarySegmentStore()) {
            ObserverTracker observerTracker = new ObserverTracker((Observable)segmentNodeStore);
            observerTracker.start(this.cfg.getBundleContext());
            this.registerCloseable(observerTracker);
        }
        if (this.cfg.isPrimarySegmentStore()) {
            this.registerCloseable(this.registerMBean(CheckpointMBean.class, new SegmentCheckpointMBean(segmentNodeStore), "CheckpointManager", "Segment node store checkpoint management"));
        }
        if (this.cfg.registerDescriptors()) {
            GenericDescriptors clusterIdDesc = new GenericDescriptors();
            clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore)), true, false);
            this.registerCloseable(this.register(Descriptors.class, clusterIdDesc));
            this.registerCloseable(this.register(Descriptors.class, new SegmentDiscoveryLiteDescriptors(segmentNodeStore)));
        }
        if (!this.cfg.isSecondarySegmentStore() && this.cfg.hasCustomBlobStore() && SharedDataStoreUtils.isShared((BlobStore)this.cfg.getBlobStore())) {
            SharedDataStore sharedDataStore = (SharedDataStore)this.cfg.getBlobStore();
            try {
                sharedDataStore.setRepositoryId(ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
            if (this.cfg.getBlobStore() instanceof BlobTrackingStore) {
                BlobTrackingStore trackingStore = (BlobTrackingStore)this.cfg.getBlobStore();
                if (trackingStore.getTracker() != null) {
                    trackingStore.getTracker().close();
                }
                trackingStore.addTracker((BlobTracker)BlobIdTracker.build((String)this.cfg.getRepositoryHome(), (String)ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore), (long)this.cfg.getBlobSnapshotInterval(), (SharedDataStore)sharedDataStore));
            }
        }
        if (!this.cfg.isSecondarySegmentStore() && this.cfg.hasCustomBlobStore() && this.cfg.getBlobStore() instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector((BlobReferenceRetriever)new SegmentBlobReferenceRetriever(store), (GarbageCollectableBlobStore)this.cfg.getBlobStore(), (Executor)executor, TimeUnit.SECONDS.toMillis(this.cfg.getBlobGcMaxAge()), ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore), this.cfg.getWhiteboard(), this.cfg.getStatisticsProvider());
            this.registerCloseable(this.registerMBean(BlobGCMBean.class, new BlobGC((BlobGarbageCollector)gc, (Executor)executor), "BlobGarbageCollection", "Segment node store blob garbage collection"));
        }
        this.registerCloseable(this.registerMBean(FileStoreBackupRestoreMBean.class, new FileStoreBackupRestoreImpl(segmentNodeStore, store.getRevisions(), store.getReader(), this.cfg.getBackupDirectory(), (Executor)executor), "FileStoreBackupRestore", "Segment node store backup/restore"));
        this.registerCloseable(this.registerMBean(SegmentNodeStoreStatsMBean.class, segmentNodeStore.getStats(), "SegmentStoreStats", "SegmentNodeStore statistics"));
        if (this.cfg.isPrimarySegmentStore()) {
            this.cfg.getLogger().info("Primary SegmentNodeStore initialized");
        } else {
            this.cfg.getLogger().info("Secondary SegmentNodeStore initialized, role={}", (Object)this.cfg.getRole());
        }
        this.registerCloseable(this.register(SegmentStoreProvider.class, new DefaultSegmentStoreProvider(store)));
        if (this.cfg.isStandbyInstance()) {
            return segmentNodeStore;
        }
        if (this.cfg.isPrimarySegmentStore()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("service.pid", SegmentNodeStore.class.getName());
            props.put("oak.nodestore.description", new String[]{"nodeStoreType=segment"});
            this.registerCloseable(this.register(NodeStore.class, segmentNodeStore, props));
        }
        return segmentNodeStore;
    }

    private <T> Registration registerMBean(Class<T> clazz, T bean, String type, String name) {
        return this.registerMBean(clazz, bean, type, name, new HashMap<String, String>());
    }

    private <T> Registration registerMBean(Class<T> clazz, T bean, String type, String name, Map<String, String> attributes) {
        return WhiteboardUtils.registerMBean((Whiteboard)this.cfg.getWhiteboard(), clazz, bean, (String)type, (String)this.maybeAppendRole(name), this.maybePutRoleAttribute(attributes));
    }

    private <T> Registration register(Class<T> clazz, T service) {
        return this.register(clazz, service, new HashMap<String, Object>());
    }

    private <T> Registration register(Class<T> clazz, T service, Map<String, Object> properties) {
        return this.cfg.getWhiteboard().register(clazz, service, this.maybePutRoleProperty(properties));
    }

    private String maybeAppendRole(String name) {
        if (this.cfg.getRole() != null) {
            return name + " - " + this.cfg.getRole();
        }
        return name;
    }

    private String jmxRole() {
        return this.cfg.getRole().replaceAll(":", "-");
    }

    private Map<String, String> maybePutRoleAttribute(Map<String, String> attributes) {
        if (this.cfg.getRole() != null) {
            attributes.put("role", this.jmxRole());
        }
        return attributes;
    }

    private Map<String, Object> maybePutRoleProperty(Map<String, Object> attributes) {
        if (this.cfg.getRole() != null) {
            attributes.put("role", this.cfg.getRole());
        }
        return attributes;
    }

    private void registerCloseable(Closeable c) {
        this.cfg.getCloser().register(c);
    }

    private void registerCloseable(AbstractServiceTracker<?> t) {
        this.registerCloseable(() -> t.stop());
    }

    private void registerCloseable(Registration r) {
        this.registerCloseable(() -> ((Registration)r).unregister());
    }

    private void registerCloseable(ObserverTracker t) {
        this.registerCloseable(() -> ((ObserverTracker)t).stop());
    }

    static interface Configuration {
        public boolean isPrimarySegmentStore();

        public boolean isSecondarySegmentStore();

        public boolean isStandbyInstance();

        public String getRole();

        public int getRetainedGenerations();

        public int getDefaultRetainedGenerations();

        public boolean getPauseCompaction();

        public int getRetryCount();

        public int getForceCompactionTimeout();

        public long getSizeDeltaEstimation();

        public int getMemoryThreshold();

        public boolean getDisableEstimation();

        public long getGCProcessLog();

        public File getSegmentDirectory();

        public File getSplitPersistenceDirectory();

        public int getSegmentCacheSize();

        public int getStringCacheSize();

        public int getTemplateCacheSize();

        public int getStringDeduplicationCacheSize();

        public int getTemplateDeduplicationCacheSize();

        public int getNodeDeduplicationCacheSize();

        public int getMaxFileSize();

        public boolean getMemoryMapping();

        public boolean hasCustomBlobStore();

        public boolean hasCustomSegmentStore();

        public boolean hasSplitPersistence();

        public boolean hasCachePersistence();

        public boolean registerDescriptors();

        public boolean dispatchChanges();

        public String getRepositoryHome();

        public long getBlobSnapshotInterval();

        public long getBlobGcMaxAge();

        public File getBackupDirectory();

        public Whiteboard getWhiteboard();

        public Closer getCloser();

        public Logger getLogger();

        public StatisticsProvider getStatisticsProvider();

        public BlobStore getBlobStore();

        public SegmentNodeStorePersistence getSegmentNodeStorePersistence();

        public PersistentCache getPersistentCache();

        public BundleContext getBundleContext();
    }
}

