/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;

public class RDBCreator {
    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        String url = null;
        String user = null;
        String pw = null;
        String db = null;
        try {
            url = args[0];
            user = args[1];
            pw = args[2];
            db = args[3];
        }
        catch (IndexOutOfBoundsException ex) {
            System.err.println("Usage: ... " + RDBCreator.class.getName() + " JDBC-URL username password databasename");
            System.exit(2);
        }
        String driver = RDBJDBCTools.driverForDBType(RDBJDBCTools.jdbctype(url));
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Attempt to load class " + driver + " failed.");
        }
        Connection c = DriverManager.getConnection(url, user, pw);
        Statement stmt = c.createStatement();
        stmt.execute("create database " + db);
        stmt.close();
        c.close();
        System.out.println("Database " + db + " created @ " + url + " using " + driver);
    }
}

