/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.jmx;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.jetbrains.annotations.NotNull;

public class PropertyIndexAsyncReindex
implements PropertyIndexAsyncReindexMBean {
    public static final String OP_NAME = "Property index asynchronous reindex";
    private final AsyncIndexUpdate async;
    private final Executor executor;
    private ManagementOperation<String> arOp = ManagementOperation.done((String)"Property index asynchronous reindex", (Object)"");

    public PropertyIndexAsyncReindex(@NotNull AsyncIndexUpdate async, @NotNull Executor executor) {
        this.async = (AsyncIndexUpdate)Preconditions.checkNotNull((Object)async);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    @Override
    @NotNull
    public CompositeData startPropertyIndexAsyncReindex() {
        if (this.arOp.isDone()) {
            this.arOp = ManagementOperation.newManagementOperation((String)OP_NAME, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    long t0 = System.nanoTime();
                    boolean done = false;
                    while (!done) {
                        PropertyIndexAsyncReindex.this.async.run();
                        done = PropertyIndexAsyncReindex.this.async.isFinished();
                    }
                    return "Reindex completed in " + ManagementOperation.Status.formatTime((long)(System.nanoTime() - t0));
                }
            });
            this.executor.execute((Runnable)this.arOp);
        }
        return this.getPropertyIndexAsyncReindexStatus();
    }

    @Override
    @NotNull
    public CompositeData getPropertyIndexAsyncReindexStatus() {
        return this.arOp.getStatus().toCompositeData();
    }
}

