/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.jackrabbit.oak.segment.standby.server.StateConsumer;

class StateHandler
extends ChannelInboundHandlerAdapter {
    private final StateConsumer consumer;

    StateHandler(StateConsumer consumer) {
        this.consumer = consumer;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.consumer.consumeState("channel registered");
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.consumer.consumeState("channel active");
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.consumer.consumeState("channel inactive");
        super.channelInactive(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.consumer.consumeState("channel unregistered");
        super.channelUnregistered(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.consumer.consumeState("got message");
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.consumer.consumeState("exception occurred: " + cause.getMessage());
        super.exceptionCaught(ctx, cause);
    }
}

