/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.ddwe.model.DragAndDropWebEditorStore;
import org.silverpeas.core.contribution.content.renderer.ContributionContentRenderer;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.ContributionContent;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.ddwe.DragAndDropEditorContent;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.util.StringUtil;

public class InfoLetter
extends SilverpeasBean
implements Comparable<InfoLetter> {
    private static final long serialVersionUID = -4798869204934629386L;
    public static final String TYPE = "Lettre";
    public static final String TEMPLATE_ID = "template";
    private String instanceId;
    private String name;
    private String description;
    private String periode;
    private WysiwygContent templateContent;

    public InfoLetter() {
        this.instanceId = "";
        this.name = "";
        this.description = "";
        this.periode = "";
    }

    public InfoLetter(WAPrimaryKey pk, String instanceId, String name, String description, String periode) {
        this.setPK(pk);
        this.instanceId = instanceId;
        this.name = name;
        this.description = description;
        this.periode = periode;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPeriode() {
        return this.periode;
    }

    public void setPeriode(String periode) {
        this.periode = periode;
    }

    @Override
    public int compareTo(@NonNull InfoLetter obj) {
        Objects.requireNonNull(obj);
        return String.valueOf(this.getPK().getId()).compareTo(String.valueOf(obj.getPK().getId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfoLetter)) {
            return false;
        }
        InfoLetter that = (InfoLetter)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getPK().getId()).append((Object)this.getPK().getInstanceId()).toHashCode();
    }

    @NonNull
    protected String getTableName() {
        return "SC_IL_Letter";
    }

    public boolean existsTemplateContent() {
        return Optional.of(new DragAndDropWebEditorStore(this.getTemplateIdentifier())).map(DragAndDropWebEditorStore::getFile).map(SilverpeasFile::exists).filter(Boolean.TRUE::equals).orElseGet(() -> this.getTemplateWysiwygContent().map(ContributionContent::getRenderer).map(ContributionContentRenderer::renderEdition).filter(StringUtil::isDefined).filter(Predicate.not("<body></body>"::equalsIgnoreCase)).isPresent());
    }

    public Optional<WysiwygContent> getTemplateWysiwygContent() {
        if (this.templateContent == null) {
            ContributionIdentifier templateId = this.getTemplateIdentifier();
            this.templateContent = WysiwygController.get((String)templateId.getComponentInstanceId(), (String)templateId.getLocalId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        }
        return Optional.ofNullable(this.templateContent);
    }

    public void saveTemplateContent(String manualContent) {
        this.templateContent = null;
        ContributionIdentifier templateId = this.getTemplateIdentifier();
        String wysiwygContent = manualContent;
        if (StringUtil.isNotDefined((String)manualContent)) {
            DragAndDropWebEditorStore store = new DragAndDropWebEditorStore(templateId);
            wysiwygContent = store.getFile().getContainer().getTmpContent().map(DragAndDropWebEditorStore.Content::getValue).map(c -> {
                store.getFile().getContainer().getOrCreateContent().setValue(c);
                store.save();
                return new DragAndDropEditorContent(c).getInlinedHtml();
            }).orElse(manualContent);
        }
        WysiwygController.updateFileAndAttachment((String)wysiwygContent, (String)templateId.getComponentInstanceId(), (String)templateId.getLocalId(), (String)User.getCurrentUser().getId(), (String)I18NHelper.DEFAULT_LANGUAGE);
    }

    public ContributionIdentifier getTemplateIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)(TEMPLATE_ID + this.getPK().getId()), (String)TYPE);
    }
}

