/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.binaries;

import java.io.IOException;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndex;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexLoaderV1;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexLoaderV2;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;

public class BinaryReferencesIndexLoader {
    private BinaryReferencesIndexLoader() {
    }

    public static Buffer loadBinaryReferencesIndex(ReaderAtEnd reader) throws IOException, InvalidBinaryReferencesIndexException {
        switch (BinaryReferencesIndexLoader.readMagic(reader)) {
            case 170934794: {
                return BinaryReferencesIndexLoaderV1.loadBinaryReferencesIndex(reader);
            }
            case 171000330: {
                return BinaryReferencesIndexLoaderV2.loadBinaryReferencesIndex(reader);
            }
        }
        throw new InvalidBinaryReferencesIndexException("Unrecognized magic number");
    }

    public static BinaryReferencesIndex parseBinaryReferencesIndex(Buffer buffer) throws InvalidBinaryReferencesIndexException {
        switch (BinaryReferencesIndexLoader.readMagic(buffer)) {
            case 170934794: {
                return BinaryReferencesIndexLoaderV1.parseBinaryReferencesIndex(buffer);
            }
            case 171000330: {
                return BinaryReferencesIndexLoaderV2.parseBinaryReferencesIndex(buffer);
            }
        }
        throw new InvalidBinaryReferencesIndexException("Unrecognized magic number");
    }

    private static int readMagic(ReaderAtEnd reader) throws IOException {
        return reader.readAtEnd(4, 4).getInt();
    }

    private static int readMagic(Buffer buffer) {
        buffer.position(buffer.limit() - 4);
        int magic = buffer.getInt();
        buffer.rewind();
        return magic;
    }
}

