/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.name;

import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NameValidator
extends DefaultValidator {
    private static final Logger LOG = LoggerFactory.getLogger(NameValidator.class);
    private final NodeState namespaces;
    private final Set<String> prefixes;
    private final boolean initPhase;
    private final boolean strictInitialNSChecks = Instrumented.getBoolean((String)"oak.strictInitialNSChecks", (String)"org.apache.jackrabbit.oak.plugins.name.NameValidator");

    NameValidator(NodeState namespaces, boolean initPhase) {
        this.namespaces = namespaces;
        this.prefixes = Sets.newHashSet((Iterable)namespaces.getChildNode("rep:nsdata").getStrings("rep:prefixes"));
        this.initPhase = initPhase;
    }

    protected static String getPrintableName(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            sb.append(String.format("\\u%04x", c));
        }
        return sb.toString();
    }

    protected void checkValidName(String name) throws CommitFailedException {
        String local;
        int n;
        int colon = name.indexOf(58);
        if (colon > 0) {
            String prefix = name.substring(0, colon);
            this.checkPrefix(prefix);
        }
        if ((n = (local = name.substring(colon + 1)).length()) > 3 && local.charAt(n - 1) == ']') {
            int i;
            for (i = n - 2; i > 1 && Character.isDigit(local.charAt(i)); --i) {
            }
            if (local.charAt(i) != '[') {
                throw new CommitFailedException("Name", 2, "Invalid name index in: " + NameValidator.getPrintableName(name));
            }
            local = local.substring(0, i);
        }
        if (!Namespaces.isValidLocalName(local)) {
            throw new CommitFailedException("Name", 3, "Invalid name: " + NameValidator.getPrintableName(name));
        }
    }

    private void checkPrefix(String prefix) throws CommitFailedException {
        if (prefix.isEmpty() || !NameValidator.contains(this.prefixes, this.namespaces, prefix)) {
            String msg = "Invalid namespace prefix(" + this.prefixes + "): " + prefix;
            if (this.initPhase && !this.strictInitialNSChecks) {
                LOG.warn(msg);
                return;
            }
            throw new CommitFailedException("Name", 1, msg);
        }
    }

    private static boolean contains(Set<String> prefixes, NodeState namespaces, String prefix) {
        return prefixes.contains(prefix) || Namespaces.collectNamespaces(namespaces.getProperties()).containsKey(prefix);
    }

    protected void checkValidValue(PropertyState property) throws CommitFailedException {
        block4: {
            block3: {
                if (!Type.NAME.equals((Object)property.getType()) && !Type.NAMES.equals((Object)property.getType())) break block3;
                for (String value : (Iterable)property.getValue(Type.NAMES)) {
                    this.checkValidValue(value);
                }
                break block4;
            }
            if (!Type.PATH.equals((Object)property.getType()) && !Type.PATHS.equals((Object)property.getType())) break block4;
            for (String value : (Iterable)property.getValue(Type.PATHS)) {
                for (String name : PathUtils.elements((String)value)) {
                    this.checkValidValue(name);
                }
            }
        }
    }

    protected void checkValidValue(String value) throws CommitFailedException {
        this.checkValidName(value);
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.checkValidName(after.getName());
        this.checkValidValue(after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.checkValidValue(after);
    }

    public void propertyDeleted(PropertyState before) {
    }

    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (!NodeStateUtils.isHidden((String)name)) {
            this.checkValidName(name);
        }
        return this;
    }

    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        return this;
    }

    public Validator childNodeDeleted(String name, NodeState before) {
        return null;
    }
}

