/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.model.MembershipStatus;
import org.silverpeas.components.community.repository.CommunityMembershipRepository;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;

@Entity
@Table(name="SC_Community_Membership")
@NamedQueries(value={@NamedQuery(name="byUserIdAndByCommunity", query="select m from CommunityMembership m where m.userId = :userId and m.community = :community and (m.status = org.silverpeas.components.community.model.MembershipStatus.COMMITTED or m.status = org.silverpeas.components.community.model.MembershipStatus.PENDING)"), @NamedQuery(name="allNonRemoved", query="select m from CommunityMembership m where m.community = :community and m.status <> org.silverpeas.components.community.model.MembershipStatus.REMOVED order by m.lastUpdateDate desc")})
public class CommunityMembership
extends SilverpeasJpaEntity<CommunityMembership, UuidIdentifier> {
    @OneToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="community", referencedColumnName="id")
    @NotNull
    private CommunityOfUsers community;
    @Column(nullable=false)
    @NotNull
    private int userId;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private MembershipStatus status;
    private Instant joiningDate;
    private transient User user;

    static CommunityMembership asMember(User user, CommunityOfUsers community) {
        CommunityMembership member = new CommunityMembership();
        member.user = user;
        member.userId = Integer.parseInt(user.getId());
        member.community = community;
        member.status = MembershipStatus.COMMITTED;
        return member;
    }

    protected CommunityMembership() {
    }

    @Nonnull
    public CommunityOfUsers getCommunity() {
        return this.community;
    }

    @Nonnull
    public User getUser() {
        if (this.user == null) {
            this.user = User.getById((String)String.valueOf(this.userId));
        }
        return this.user;
    }

    @Nonnull
    public MembershipStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getJoiningDate() {
        return this.joiningDate == null ? null : OffsetDateTime.ofInstant(this.joiningDate, ZoneOffset.UTC);
    }

    public SilverpeasRole getMemberRole() {
        Set roles = this.community.getCommunitySpace().getAllSpaceProfilesOfUser(String.valueOf(this.userId)).stream().map(BaseRightProfile::getName).map(SilverpeasRole::fromString).collect(Collectors.toSet());
        return roles.isEmpty() ? null : SilverpeasRole.getHighestFrom(roles);
    }

    void setStatus(MembershipStatus newStatus) {
        this.status = newStatus;
    }

    void save() {
        if (this.status == MembershipStatus.REMOVED) {
            throw new IllegalStateException("The user isn't anymore member of the community and as such its state cannot be updated");
        }
        Transaction.performInOne(() -> {
            if (this.status == MembershipStatus.COMMITTED && this.joiningDate == null) {
                this.joiningDate = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
            }
            CommunityMembershipRepository.get().save((IdentifiableEntity)this);
            return null;
        });
    }

    void delete() {
        if (this.status == MembershipStatus.PENDING) {
            throw new IllegalStateException("A pending membership of a user in the community cannot be removed! It can be only refused or validated");
        }
        Transaction.performInOne(() -> {
            this.status = MembershipStatus.REMOVED;
            CommunityMembershipRepository.get().save((IdentifiableEntity)this);
            return null;
        });
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

