/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import java.util.UUID;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditor;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorOld;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndexEditorProvider.class})
public class NodeCounterEditorProvider
implements IndexEditorProvider {
    public static final String TYPE = "counter";
    public static final String RESOLUTION = "resolution";
    public static final String SEED = "seed";
    @Reference
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;

    @Override
    @Nullable
    public Editor getIndexEditor(@NotNull String type, @NotNull NodeBuilder definition, @NotNull NodeState root, @NotNull IndexUpdateCallback callback) throws CommitFailedException {
        long seed;
        if (!TYPE.equals(type)) {
            return null;
        }
        PropertyState s = definition.getProperty(RESOLUTION);
        int resolution = s == null ? 1000 : ((Long)s.getValue(Type.LONG)).intValue();
        s = definition.getProperty(SEED);
        if (s != null) {
            seed = ((Long)s.getValue(Type.LONG)).intValue();
        } else {
            seed = 0L;
            if (NodeCounter.COUNT_HASH) {
                seed = UUID.randomUUID().getMostSignificantBits();
                definition.setProperty(SEED, (Object)seed);
            }
        }
        if (NodeCounter.USE_OLD_COUNTER) {
            NodeCounterEditorOld.NodeCounterRoot rootData = new NodeCounterEditorOld.NodeCounterRoot(resolution, seed, definition, root, callback);
            return new NodeCounterEditorOld(rootData, null, "/", null);
        }
        NodeCounterEditor.NodeCounterRoot rootData = new NodeCounterEditor.NodeCounterRoot(resolution, seed, definition, root, callback);
        return new NodeCounterEditor(rootData, this.mountInfoProvider, this.statisticsProvider);
    }

    public NodeCounterEditorProvider with(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
        return this;
    }

    public NodeCounterEditorProvider with(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        return this;
    }
}

