/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStoreUtil.class);

    private FileStoreUtil() {
    }

    static RecordId findPersistedRecordId(SegmentStore store, SegmentIdProvider idProvider, JournalFile journalFile) throws IOException {
        try (JournalReader journalReader = new JournalReader(journalFile);){
            while (journalReader.hasNext()) {
                RecordId id;
                JournalEntry entry;
                block10: {
                    entry = (JournalEntry)journalReader.next();
                    id = RecordId.fromString(idProvider, entry.getRevision());
                    if (!store.containsSegment(id.getSegmentId())) break block10;
                    RecordId recordId = id;
                    return recordId;
                }
                try {
                    log.warn("Unable to access revision {}, rewinding...", (Object)id);
                }
                catch (IllegalArgumentException ignore) {
                    log.warn("Skipping invalid record id {}", (Object)entry);
                }
            }
        }
        return null;
    }
}

