/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeDefinitionWriter;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrivilegeInitializer
implements RepositoryInitializer,
PrivilegeConstants {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeInitializer.class);
    private final RootProvider rootProvider;

    PrivilegeInitializer(@NotNull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    public void initialize(@NotNull NodeBuilder builder) {
        if (!builder.hasChildNode("jcr:system")) {
            throw new IllegalStateException("Missing jcr:system node, NodeStore not initialized.");
        }
        NodeBuilder system = builder.getChildNode("jcr:system");
        if (!system.hasChildNode("rep:privileges")) {
            NodeBuilder privileges = system.child("rep:privileges");
            privileges.setProperty("jcr:primaryType", (Object)"rep:Privileges", Type.NAME);
            NodeState base = ModifiedNodeState.squeeze((NodeState)builder.getNodeState());
            MemoryNodeStore store = new MemoryNodeStore(base);
            try {
                Root systemRoot = this.rootProvider.createSystemRoot((NodeStore)store, null);
                new PrivilegeDefinitionWriter(systemRoot).writeBuiltInDefinitions();
            }
            catch (RepositoryException e) {
                log.error("Failed to register built-in privileges", (Throwable)e);
                throw new RuntimeException(e);
            }
            NodeState target = store.getRoot();
            target.compareAgainstBaseState(base, (NodeStateDiff)new ApplyDiff(builder));
        }
    }
}

