/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.annotation.Nonnull;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.NewsPK;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.kernel.logging.SilverLogger;

public class NewsSelection
extends ClipboardSelection {
    private static final long serialVersionUID = 2873891019350833299L;
    private final News currentNews;
    public static final DataFlavor NewsFlavor = new DataFlavor(News.class, "News");

    public NewsSelection(News news) {
        this.currentNews = news;
        super.addFlavor(NewsFlavor);
    }

    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferredData;
        try {
            transferredData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (NewsFlavor.equals(parFlavor)) {
                transferredData = this.currentNews;
            }
            throw e;
        }
        return transferredData;
    }

    public IndexEntry getIndexEntry() {
        NewsPK newsPK = this.currentNews.getPK();
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(newsPK.getComponentName(), this.currentNews.getContributionType(), newsPK.getId()));
        indexEntry.setTitle(this.currentNews.getName());
        return indexEntry;
    }

    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData();
        keyData.setTitle(this.currentNews.getName());
        keyData.setAuthor(this.currentNews.getCreatorId());
        keyData.setCreationDate(this.currentNews.getCreationDate());
        keyData.setDesc(this.currentNews.getDescription());
        this.currentNews.getVisibility().getSpecificPeriod().ifPresent(v -> {
            try {
                if (!v.startsAtMinDate()) {
                    keyData.setProperty("BEGINDATE", v.getStartDate().toString());
                }
                if (!v.endsAtMaxDate()) {
                    keyData.setProperty("ENDDATE", v.getEndDate().toString());
                }
            }
            catch (SKDException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            }
        });
        return keyData;
    }
}

