/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import java.io.IOException;
import java.util.Optional;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.SplitJournalFileReader;

public class SplitJournalFile
implements JournalFile {
    private final JournalFile roJournalFile;
    private final JournalFile rwJournalFile;
    private final Optional<String> lastRoJournalEntry;

    public SplitJournalFile(JournalFile roJournalFile, JournalFile rwJournalFile, Optional<String> lastRoJournalEntry) {
        this.roJournalFile = roJournalFile;
        this.rwJournalFile = rwJournalFile;
        this.lastRoJournalEntry = lastRoJournalEntry;
    }

    @Override
    public JournalFileReader openJournalReader() throws IOException {
        return new SplitJournalFileReader(this.roJournalFile.openJournalReader(), this.rwJournalFile.openJournalReader(), this.lastRoJournalEntry);
    }

    @Override
    public JournalFileWriter openJournalWriter() throws IOException {
        return this.rwJournalFile.openJournalWriter();
    }

    @Override
    public String getName() {
        return this.rwJournalFile.getName();
    }

    @Override
    public boolean exists() {
        return this.roJournalFile.exists() || this.rwJournalFile.exists();
    }
}

