/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.ArrayList;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class AnnotatingConflictHandler
implements ThreeWayConflictHandler {
    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_CHANGED_PROPERTY).setProperty(ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_PROPERTY).setProperty(theirs);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_PROPERTY).setProperty(base);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution addExistingNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState theirs) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.ADD_EXISTING_NODE).setChildNode(name, ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution changeDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.createChild(marker, ConflictType.CHANGE_DELETED_NODE).setChildNode(name, ours);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteChangedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState theirs, @NotNull NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_CHANGED_NODE), name);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    @NotNull
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState base) {
        NodeBuilder marker = AnnotatingConflictHandler.addConflictMarker(parent);
        AnnotatingConflictHandler.markChild(AnnotatingConflictHandler.createChild(marker, ConflictType.DELETE_DELETED_NODE), name);
        return ThreeWayConflictHandler.Resolution.THEIRS;
    }

    private static NodeBuilder addConflictMarker(@NotNull NodeBuilder parent) {
        ArrayList mixins = Lists.newArrayList((Iterable)parent.getNames("jcr:mixinTypes"));
        if (mixins.add("rep:MergeConflict")) {
            parent.setProperty("jcr:mixinTypes", (Object)mixins, Type.NAMES);
        }
        NodeBuilder repOurs = parent.child("rep:ours");
        repOurs.setProperty("jcr:primaryType", (Object)"rep:Unstructured", Type.NAME);
        return repOurs;
    }

    @NotNull
    private static NodeBuilder createChild(@NotNull NodeBuilder parent, @NotNull ConflictType ct) {
        return parent.child(ct.getName());
    }

    private static void markChild(@NotNull NodeBuilder parent, @NotNull String name) {
        parent.child(name);
    }
}

