/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.model;

import java.util.Date;
import org.silverpeas.core.personalorganizer.model.Schedulable;
import org.silverpeas.core.personalorganizer.model.TodoDetail;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class ToDoHeader
extends Schedulable
implements Cloneable {
    private static final long serialVersionUID = -8938831646589260261L;
    public static final int PERCENT_UNDEFINED = -1;
    public static final int DURATION_UNDEFINED = -1;
    private int percentCompleted = -1;
    private Date completedDate = null;
    private String componentId = null;
    private String spaceId = null;
    private int duration = -1;

    public static ToDoHeader fromTodoDetail(TodoDetail detail) {
        ToDoHeader head = new ToDoHeader();
        head.setName(detail.getName());
        head.setId(detail.getId());
        head.setDescription(detail.getDescription());
        head.setDelegatorId(detail.getDelegatorId());
        head.setStartDate(detail.getStartDate());
        head.setEndDate(detail.getEndDate());
        head.setDuration((int)detail.getDuration());
        head.setPercentCompleted(detail.getPercentCompleted());
        head.setComponentId(detail.getComponentId());
        head.setSpaceId(detail.getSpaceId());
        head.setExternalId(detail.getExternalId());
        return head;
    }

    public ToDoHeader() {
    }

    public ToDoHeader(String name, String organizerId) {
        super(name, organizerId);
    }

    public ToDoHeader(String id, String name, String organizerId) {
        super(id, name, organizerId);
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(int newValue) {
        this.percentCompleted = newValue;
    }

    public void setCompletedDate(Date date) {
        this.completedDate = date != null ? new Date(date.getTime()) : null;
    }

    public Date getCompletedDate() {
        if (this.completedDate != null) {
            return new Date(this.completedDate.getTime());
        }
        return this.completedDate;
    }

    public void setCompletedDay(String day) {
        try {
            this.completedDate = DateUtil.parseDate((String)day);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            this.completedDate = null;
        }
    }

    public String getCompletedDay() {
        if (this.completedDate == null) {
            return null;
        }
        return DateUtil.formatDate((Date)this.completedDate);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setSpaceId(String id) {
        this.spaceId = id;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public Schedulable getCopy() {
        try {
            return (ToDoHeader)this.clone();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return null;
        }
    }
}

