/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundledTypesRegistry;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundlingHandler;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlingConfigHandler
implements Observer,
Closeable {
    public static final String DOCUMENT_NODE_STORE = "rep:documentStore";
    public static final String BUNDLOR = "bundlor";
    public static final String CONFIG_PATH = "/jcr:system/rep:documentStore/bundlor";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private BackgroundObserver backgroundObserver;
    private Closeable observerRegistration;
    private boolean enabled;
    private volatile BundledTypesRegistry registry = BundledTypesRegistry.NOOP;
    private Editor changeDetector = new SubtreeEditor((Editor)new DefaultEditor(){

        public void leave(NodeState before, NodeState after) throws CommitFailedException {
            BundlingConfigHandler.this.recreateRegistry(after);
        }
    }, (String[])Iterables.toArray((Iterable)PathUtils.elements((String)"/jcr:system/rep:documentStore/bundlor"), String.class));

    public synchronized void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        EditorDiff.process((Editor)this.changeDetector, (NodeState)this.root, (NodeState)root);
        this.root = root;
    }

    public BundlingHandler newBundlingHandler() {
        return new BundlingHandler(this.registry);
    }

    public void initialize(Observable nodeStore, Executor executor) {
        this.registerObserver(nodeStore, executor);
        this.enabled = true;
        this.log.info("Bundling of nodes enabled");
    }

    @Override
    public void close() throws IOException {
        this.unregisterObserver();
    }

    public BackgroundObserverMBean getMBean() {
        return ((BackgroundObserver)Preconditions.checkNotNull((Object)this.backgroundObserver)).getMBean();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    BundledTypesRegistry getRegistry() {
        return this.registry;
    }

    private void recreateRegistry(NodeState nodeState) {
        this.registry = BundledTypesRegistry.from(nodeState);
        this.log.info("Refreshing the BundledTypesRegistry");
    }

    private void registerObserver(Observable observable, Executor executor) {
        this.backgroundObserver = new BackgroundObserver((Observer)this, executor, 5);
        this.observerRegistration = observable.addObserver((Observer)this.backgroundObserver);
    }

    public void unregisterObserver() throws IOException {
        if (this.backgroundObserver != null) {
            this.observerRegistration.close();
            this.backgroundObserver.close();
            this.observerRegistration = null;
            this.backgroundObserver = null;
        }
    }
}

