/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"felix.inventory.printer.name=oak-document-store-stats", "felix.inventory.printer.title=Oak DocumentStore Statistics", "felix.inventory.printer.format=TEXT"})
public class DocumentStoreStatsPrinter
implements InventoryPrinter {
    @Reference
    DocumentNodeStore nodeStore;

    public void print(PrintWriter pw, Format format, boolean isZip) {
        if (format != Format.TEXT) {
            return;
        }
        DocumentStore store = this.nodeStore.getDocumentStore();
        this.printTitle(pw, "DocumentStore metadata");
        this.print(pw, store.getMetadata());
        pw.println();
        this.printTitle(pw, "DocumentStore statistics");
        this.print(pw, store.getStats());
        pw.flush();
    }

    private void printTitle(PrintWriter pw, String title) {
        pw.println(title);
        pw.println(Strings.repeat((String)"=", (int)title.length()));
    }

    private void print(PrintWriter pw, Map<String, String> data) {
        TreeMap<String, String> sortedData = new TreeMap<String, String>(data);
        sortedData.forEach((k, v) -> pw.println(k + "=" + v));
    }
}

