/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.kmelia.KmeliaCopyDetail;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.admin.component.ApplicationResourcePasting;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcManager;

@Service
@Named(value="kmeliaResourcePasting")
public class KmeliaResourcePasting
implements ApplicationResourcePasting {
    @Inject
    private PdcManager pdcManager;
    @Inject
    private PdcClassificationService classificationService;
    @Inject
    private NodeService nodeService;
    @Inject
    private KmeliaService kmeliaService;

    @Transactional
    public void paste(PasteDetail pasteDetail) {
        String fromComponentId = pasteDetail.getFromComponentId();
        String toComponentId = pasteDetail.getToComponentId();
        try {
            List usedAxis = this.pdcManager.getUsedAxisByInstanceId(fromComponentId);
            for (UsedAxis axis : usedAxis) {
                UsedAxis copy = axis.copy();
                copy.setInstanceId(toComponentId);
                this.pdcManager.addUsedAxis(copy);
            }
        }
        catch (PdcException e) {
            throw new KmeliaRuntimeException(e.getMessage());
        }
        PdcClassification appClassification = this.classificationService.getPreDefinedClassification(fromComponentId);
        if (!appClassification.isEmpty() && appClassification.isPredefinedForTheWholeComponentInstance()) {
            PdcClassification copy = appClassification.copy().inComponentInstance(toComponentId);
            this.classificationService.savePreDefinedClassification(copy);
        }
        KmeliaCopyDetail copyDetail = new KmeliaCopyDetail(pasteDetail);
        copyDetail.addOption("PasteOption_NodeRights", "true");
        copyDetail.addOption("PasteOption_AdministrativeOperation", Boolean.TRUE.toString());
        NodePK rootPK = new NodePK("0", fromComponentId);
        NodePK targetPK = new NodePK("0", toComponentId);
        if (copyDetail.isPublicationHeaderMustBeCopied()) {
            copyDetail.setFromNodePK(rootPK);
            copyDetail.setToNodePK(targetPK);
            this.kmeliaService.copyPublications(copyDetail);
        }
        WysiwygController.copy((String)fromComponentId, (String)"Node_0", (String)toComponentId, (String)"Node_0", (String)pasteDetail.getUserId());
        List firstLevelNodes = this.nodeService.getHeadersByLevel(rootPK, 2);
        for (NodeDetail nodeToPaste : firstLevelNodes) {
            if (!nodeToPaste.isChild()) continue;
            copyDetail.setFromNodePK(nodeToPaste.getNodePK());
            copyDetail.setToNodePK(targetPK);
            this.kmeliaService.copyNode(copyDetail);
        }
    }
}

