/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.websites.model.SiteDetail;
import org.silverpeas.components.websites.model.SitePK;
import org.silverpeas.components.websites.service.WebSiteService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;

@Service
public class WebSitesContentManager
extends AbstractSilverpeasContentManager
implements Serializable {
    private static final long serialVersionUID = -8992766242253326927L;
    private static final String WEB_SITES_CONTENT_ICON_FILE_NAME = "webSitesSmall.gif";
    private static final String BOOKMARK_CONTENT_ICON_FILE_NAME = "bookmarkSmall.gif";

    protected WebSitesContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        if (componentInstanceId.startsWith("bookmark")) {
            return BOOKMARK_CONTENT_ICON_FILE_NAME;
        }
        return WEB_SITES_CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getWebSiteService().getWebSite(componentInstanceId, resourceId));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        return resourceReferences.stream().collect(Collectors.groupingBy(ResourceReference::getComponentInstanceId, Collectors.mapping(ResourceReference::getLocalId, Collectors.toList()))).entrySet().stream().flatMap(e -> this.getWebSiteService().getWebSites((String)e.getKey(), (List)e.getValue()).stream()).collect(Collectors.toList());
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        SiteDetail siteDetail = (SiteDetail)contribution;
        return new SilverContentVisibility(this.isVisible(siteDetail));
    }

    public void deleteSilverContent(Connection con, SitePK sitePK) throws ContentManagerException {
        this.deleteSilverContent(con, sitePK.getId(), sitePK.getComponentName());
    }

    private boolean isVisible(SiteDetail siteDetail) {
        return siteDetail.getState() == 1;
    }

    private WebSiteService getWebSiteService() {
        return WebSiteService.get();
    }
}

