/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.filter;

import edu.psu.swe.commons.jaxrs.RestResourceMetadata;
import edu.psu.swe.commons.jaxrs.filter.AddEtagHeader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@AddEtagHeader
public class EtagResponseFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EtagResponseFilter.class);

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity != null) {
            EntityTag etag;
            try {
                etag = RestResourceMetadata.hash(entity);
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to create ETag", e);
            }
            responseContext.getHeaders().add((Object)"ETag", (Object)etag.getValue());
        } else {
            LOG.info("Entity was null, can't create etag");
        }
    }
}

