/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.dao;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.gallery.dao.MediaOrderSQLQueryBuilder;
import org.silverpeas.components.gallery.model.MediaOrderCriteria;
import org.silverpeas.components.gallery.model.Order;
import org.silverpeas.components.gallery.model.OrderRow;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class OrderDAO {
    private static final String GALLERY_ORDER_TABLE = "SC_Gallery_Order";
    private static final String GALLERY_ORDER_DETAIL_TABLE = "SC_Gallery_OrderDetail";
    private static final String ORDER_ID_CRITERION = "orderId = ?";

    private OrderDAO() {
    }

    public static String createOrder(Collection<String> mediaIds, String userId, String instanceId) throws SQLException {
        String uuid = DBUtil.getUniqueId();
        JdbcSqlQuery insert = JdbcSqlQuery.insertInto((String)GALLERY_ORDER_TABLE);
        insert.withInsertParam("orderId", (Object)uuid);
        insert.withInsertParam("userId", (Object)userId);
        insert.withInsertParam("instanceId", (Object)instanceId);
        insert.withInsertParam("createDate", (Object)new Timestamp(new Date().getTime()));
        insert.execute();
        for (String mediaId : mediaIds) {
            OrderDAO.addOrderMedia(mediaId, uuid, instanceId);
        }
        return uuid;
    }

    private static void addOrderMedia(String mediaId, String orderId, String instanceId) throws SQLException {
        JdbcSqlQuery insert = JdbcSqlQuery.insertInto((String)GALLERY_ORDER_DETAIL_TABLE);
        insert.withInsertParam("orderId", (Object)orderId);
        insert.withInsertParam("mediaId", (Object)mediaId);
        insert.withInsertParam("instanceId", (Object)instanceId);
        insert.execute();
    }

    public static void updateOrder(Order order) throws SQLException {
        OrderDAO.updateOrderStatus(order);
        List<OrderRow> rows = order.getRows();
        for (OrderRow row : rows) {
            JdbcSqlQuery update = JdbcSqlQuery.update((String)GALLERY_ORDER_DETAIL_TABLE);
            update.withUpdateParam("downloadDecision", (Object)row.getDownloadDecision());
            update.where("orderId = ? and mediaId = ?", new Object[]{row.getOrderId(), row.getMediaId()});
            update.execute();
        }
    }

    private static void updateOrderStatus(Order order) throws SQLException {
        JdbcSqlQuery update = JdbcSqlQuery.update((String)GALLERY_ORDER_TABLE);
        update.withUpdateParam("processDate", (Object)new Timestamp(new Date().getTime()));
        update.withUpdateParam("processUser", (Object)order.getProcessUserId());
        update.where(ORDER_ID_CRITERION, new Object[]{order.getOrderId()});
        update.execute();
    }

    public static void deleteOrder(Order order) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)GALLERY_ORDER_TABLE).where(ORDER_ID_CRITERION, new Object[]{order.getOrderId()}).execute();
        List<OrderRow> orderRows = OrderDAO.getAllOrderDetails(order.getOrderId());
        if (orderRows != null) {
            for (OrderRow row : orderRows) {
                OrderDAO.deleteMediaFromOrder(row.getMediaId(), order.getOrderId());
            }
        }
    }

    private static void deleteMediaFromOrder(String mediaId, String orderId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)GALLERY_ORDER_DETAIL_TABLE).where("mediaId = ? and orderId = ?", new Object[]{mediaId, orderId}).execute();
    }

    public static List<OrderRow> getAllOrderDetails(String orderId) throws SQLException {
        return JdbcSqlQuery.select((String)"mediaId, instanceId, downloadDate, downloadDecision from SC_Gallery_OrderDetail").where(ORDER_ID_CRITERION, new Object[]{orderId}).execute(row -> {
            String mediaId = row.getString(1);
            String instanceId = row.getString(2);
            OrderRow orderRow = new OrderRow(orderId, mediaId, instanceId);
            orderRow.setDownloadDate(row.getTimestamp(3));
            orderRow.setDownloadDecision(row.getString(4));
            return orderRow;
        });
    }

    public static void updateOrderRow(OrderRow row) throws SQLException {
        JdbcSqlQuery update = JdbcSqlQuery.update((String)GALLERY_ORDER_DETAIL_TABLE);
        update.withUpdateParam("downloadDate", (Object)new Timestamp(new Date().getTime()));
        update.withUpdateParam("downloadDecision", (Object)row.getDownloadDecision());
        update.where("orderId = ? and mediaId = ?", new Object[]{row.getOrderId(), row.getMediaId()});
        update.execute();
    }

    public static Order getByCriteria(MediaOrderCriteria criteria) throws SQLException {
        return (Order)JdbcSqlQuery.unique(OrderDAO.findByCriteria(criteria));
    }

    public static List<Order> findByCriteria(MediaOrderCriteria criteria) throws SQLException {
        MediaOrderSQLQueryBuilder queryBuilder = new MediaOrderSQLQueryBuilder();
        criteria.processWith(queryBuilder);
        JdbcSqlQuery queryBuild = queryBuilder.result();
        return queryBuilder.orderingResult((List<Order>)queryBuild.execute(row -> {
            Order order = new Order(row.getString(1));
            order.setUserId(row.getString(2));
            order.setInstanceId(row.getString(3));
            order.setCreationDate(row.getTimestamp(4));
            order.setProcessDate(row.getTimestamp(5));
            order.setProcessUserId(row.getString(6));
            order.setRows(OrderDAO.getAllOrderDetails(order.getOrderId()));
            return order;
        }));
    }
}

