/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.kmelia.service.AbstractKmeliaSimulationElementLister;
import org.silverpeas.components.kmelia.service.KmeliaXmlFormUpdateContext;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.process.SimpleDocumentSimulationElement;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.process.annotation.SimulationElement;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public class KmeliaPublicationBatchSimulationElementLister
extends AbstractKmeliaSimulationElementLister {
    private final Map<PublicationPK, PublicationDetail> publicationCache;
    private final KmeliaXmlFormUpdateContext xmlFormUpdateContext;
    private final User currentUser;

    public KmeliaPublicationBatchSimulationElementLister(Map<PublicationPK, PublicationDetail> publicationCache, KmeliaXmlFormUpdateContext xmlFormUpdateContext, User currentUser) {
        this.publicationCache = publicationCache;
        this.xmlFormUpdateContext = xmlFormUpdateContext;
        this.currentUser = currentUser;
    }

    public void listElements(ResourceReference sourcePK, String language) {
        if (!(sourcePK instanceof PublicationPK) || this.xmlFormUpdateContext == null) {
            throw new IllegalArgumentException("The reference " + sourcePK.getClass().getSimpleName() + " isn't taken in charge");
        }
        this.listXmlFormDocumentsOfPublication(this.getPublicationByPk((PublicationPK)sourcePK), language);
    }

    private void listXmlFormDocumentsOfPublication(PublicationDetail publication, String language) {
        List<Pair<FileItem, FileField>> data = this.xmlFormUpdateContext.getPublicationFileFields(publication, language);
        Set existingAttachmentIdToBeRemoved = data.stream().filter(d -> Objects.nonNull(d.getFirst())).map(Pair::getSecond).map(FileField::getAttachmentId).filter(StringUtil::isDefined).collect(Collectors.toSet());
        if (!existingAttachmentIdToBeRemoved.isEmpty()) {
            AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType((ResourceReference)publication.getPK(), DocumentType.form, language).stream().filter(d -> existingAttachmentIdToBeRemoved.contains(d.getId())).forEach(d -> this.addElement((SimulationElement)new SimpleDocumentSimulationElement(d).setOld()));
        }
        data.stream().map(Pair::getFirst).filter(Objects::nonNull).map(i -> this.createDummySimpleDocument(publication, (FileItem)i, i.getName())).forEach(d -> this.addElement((SimulationElement)new SimpleDocumentSimulationElement(d)));
    }

    private PublicationDetail getPublicationByPk(PublicationPK pk) {
        return this.publicationCache.computeIfAbsent(pk, k -> this.getPublicationService().getDetail(k));
    }

    private SimpleDocument createDummySimpleDocument(PublicationDetail pub, FileItem item, String fileName) {
        SimpleAttachment attachment = SimpleAttachment.builder().setFilename(fileName + UUID.randomUUID()).setSize(item.getSize()).setContentType(FileUtil.getMimeType((String)fileName)).setCreationData(this.currentUser.getId(), new Date()).build();
        SimpleDocumentPK documentPk = new SimpleDocumentPK(null, pub.getInstanceId());
        SimpleDocument document = new SimpleDocument(documentPk, pub.getId(), 0, false, null, attachment);
        document.setDocumentType(DocumentType.form);
        document.setSize(item.getSize());
        return document;
    }
}

