/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class RequestFile {
    private final FileItem fileItem;

    public RequestFile(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public String getName() {
        return StringUtil.normalize((String)FilenameUtils.getName((String)this.fileItem.getName()));
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(this.fileItem.getInputStream());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getString() {
        try {
            return this.fileItem.getString(Charsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return this.fileItem.getString();
        }
    }

    public void writeTo(File file) throws Exception {
        this.fileItem.write(file);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try (InputStream input = this.getInputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)outputStream);
        }
    }
}

