/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.FormsOnlineDAO;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.RequestCriteria;
import org.silverpeas.components.formsonline.model.RequestPK;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQueries;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.persistence.jdbc.sql.SelectResultRowProcess;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;

public class FormsOnlineDAOJdbc
implements FormsOnlineDAO {
    private static final String FORMS_TABLENAME = "SC_FormsOnline_Forms";
    private static final String FORMS_INSTANCES_TABLENAME = "SC_FormsOnline_FormInstances";
    private static final String FORMS_INSTANCE_VALIDATIONS_TABLENAME = "SC_FormsOnline_FormInstVali";
    private static final String USER_RIGHTS_TABLENAME = "SC_FormsOnline_UserRights";
    private static final String GROUP_RIGHTS_TABLENAME = "SC_FormsOnline_GroupRights";
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String QUERY_LOAD_FORM = "SELECT * FROM SC_FormsOnline_Forms where instanceId = ? and id = ?";
    private static final String QUERY_INSERT_FORM = "INSERT INTO SC_FormsOnline_Forms(id, xmlFormName, name, description, title, creatorId, creationDate, state, instanceId, hierarchicalValidation, formInstExchangeReceiver, deleteAfterFormInstExchange) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_UPDATE_FORM = "update SC_FormsOnline_Forms set xmlFormName = ?, name = ?, description = ?, title = ?, creatorId = ?, creationDate = ?, state = ?, hierarchicalValidation = ?, formInstExchangeReceiver = ?, deleteAfterFormInstExchange = ? where instanceId = ? and id= ? ";
    private static final String QUERY_DELETE_FORM = "DELETE FROM SC_FormsOnline_Forms where instanceId = ? and id = ? ";
    private static final String COUNT_REQUESTS_BY_FORM = "select formid, count(*) from SC_FormsOnline_FormInstances where instanceId = ? group by formid";
    private static final String WHERE_FULL_RIGHT_CLAUSE = " where instanceId = ? and formId = ? and rightType = ?";
    private static final String QUERY_LOAD_USER_RIGHTS = "SELECT * FROM SC_FormsOnline_UserRights where instanceId = ? and formId = ? and rightType = ?";
    private static final String QUERY_LOAD_GROUP_RIGHTS = "SELECT * FROM SC_FormsOnline_GroupRights where instanceId = ? and formId = ? and rightType = ?";
    private static final String QUERY_REMOVE_USER_RIGHTS = "DELETE FROM SC_FormsOnline_UserRights where instanceId = ? and formId = ? and rightType = ?";
    private static final String QUERY_REMOVE_GROUP_RIGHTS = "DELETE FROM SC_FormsOnline_GroupRights where instanceId = ? and formId = ? and rightType = ?";
    private static final String QUERY_INSERT_USER_RIGHTS = "INSERT INTO SC_FormsOnline_UserRights(formId, instanceId, rightType, userId) VALUES (?, ?, ?, ?)";
    private static final String QUERY_INSERT_GROUP_RIGHTS = "INSERT INTO SC_FormsOnline_GroupRights(formId, instanceId, rightType, groupId) VALUES (?, ?, ?, ?)";
    private static final String ID = "id";
    private static final String ID_CRITERIA = "id = ?";
    private static final String STATE = "state";
    private static final String INSTANCE_ID = "instanceId";
    private static final String FORM_ID = "formId";
    private static final String CREATION_DATE = "creationDate";
    private static final String CREATOR_ID = "creatorId";
    private static final String REQUEST_MSG = "instance on form";
    private static final String FORM_INST_ID = "formInstId";
    private static final String VALIDATION_BY = "validationBy";
    private static final String RIGHT_TYPE = "rightType";
    private static final String VALIDATION_TYPE = "validationType";
    private static final String NOT_EXISTS_SELECT = "NOT EXISTS(SELECT 1";
    private static final String EXISTS_SELECT = "EXISTS(SELECT 1";
    private static final String FORM_INST_ID_CLAUSE = "formInstId = r.id";

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormDetail createForm(FormDetail formDetail) throws FormsOnlineException {
        try (Connection con = this.getConnection();){
            FormDetail formDetail2;
            block14: {
                PreparedStatement stmt = con.prepareStatement(QUERY_INSERT_FORM);
                try {
                    int id = DBUtil.getNextId((String)FORMS_TABLENAME, (String)ID);
                    stmt.setInt(1, id);
                    stmt.setString(2, formDetail.getXmlFormName());
                    stmt.setString(3, formDetail.getName());
                    stmt.setString(4, formDetail.getDescription());
                    stmt.setString(5, formDetail.getTitle());
                    stmt.setString(6, formDetail.getCreatorId());
                    FormsOnlineDAOJdbc.prepareDateStatement(stmt, 7, formDetail.getCreationDate());
                    stmt.setInt(8, formDetail.getState());
                    stmt.setString(9, formDetail.getInstanceId());
                    stmt.setBoolean(10, formDetail.isHierarchicalValidation());
                    stmt.setString(11, formDetail.getRequestExchangeReceiver().orElse(null));
                    stmt.setBoolean(12, formDetail.isDeleteAfterRequestExchange());
                    stmt.executeUpdate();
                    formDetail.setId(id);
                    formDetail2 = formDetail;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return formDetail2;
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnAdding((String)"form", (Object)formDetail.getName()), se);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormDetail deleteForm(FormPK pk) throws FormsOnlineException {
        FormDetail form = this.getForm(pk);
        try (Connection con = this.getConnection();){
            FormDetail formDetail;
            block15: {
                PreparedStatement stmt = con.prepareStatement(QUERY_DELETE_FORM);
                try {
                    for (String rightType : FormDetail.ALL_RIGHT_TYPES) {
                        this.removeGroupRights(con, pk, rightType);
                        this.removeUserRights(con, pk, rightType);
                    }
                    stmt.setString(1, pk.getInstanceId());
                    stmt.setInt(2, Integer.parseInt(pk.getId()));
                    stmt.executeUpdate();
                    formDetail = form;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return formDetail;
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnDeleting((String)"form", (Object)pk.toString()), se);
        }
    }

    @Override
    public FormDetail getForm(FormPK pk) throws FormsOnlineException {
        FormDetail form = null;
        try (Connection con = this.getConnection();
             PreparedStatement stmt = con.prepareStatement(QUERY_LOAD_FORM);){
            stmt.setString(1, pk.getInstanceId());
            stmt.setInt(2, Integer.parseInt(pk.getId()));
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    form = this.fetchFormDetail(rs);
                }
            }
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"form", (Object)pk.toString()), se);
        }
        return form;
    }

    @Override
    public List<FormDetail> findAllForms(String instanceId, String orderBy) throws FormsOnlineException {
        try {
            ArrayList<FormDetail> forms = new ArrayList<FormDetail>();
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"*").from(new String[]{FORMS_TABLENAME}).where(INSTANCE_ID, new Object[0]).in(new Object[]{instanceId}).orderBy(new String[]{orderBy});
            query.execute(r -> {
                forms.add(this.fetchFormDetail((ResultSet)r));
                return null;
            });
            return forms;
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"Available forms of instance", (Object)String.join((CharSequence)",", instanceId)), se);
        }
    }

    @Override
    public void updateForm(FormDetail formDetail) throws FormsOnlineException {
        try (Connection con = this.getConnection();
             PreparedStatement stmt = con.prepareStatement(QUERY_UPDATE_FORM);){
            stmt.setString(1, formDetail.getXmlFormName());
            stmt.setString(2, formDetail.getName());
            stmt.setString(3, formDetail.getDescription());
            stmt.setString(4, formDetail.getTitle());
            stmt.setString(5, formDetail.getCreatorId());
            FormsOnlineDAOJdbc.prepareDateStatement(stmt, 6, formDetail.getCreationDate());
            stmt.setInt(7, formDetail.getState());
            stmt.setBoolean(8, formDetail.isHierarchicalValidation());
            stmt.setString(9, formDetail.getRequestExchangeReceiver().orElse(null));
            stmt.setBoolean(10, formDetail.isDeleteAfterRequestExchange());
            stmt.setString(11, formDetail.getInstanceId());
            stmt.setInt(12, formDetail.getId());
            stmt.executeUpdate();
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnUpdate((String)"form", (Object)formDetail.getId()), se);
        }
    }

    @Override
    public List<String> getReceiversAsGroups(FormPK pk, String rightType) throws FormsOnlineException {
        return this.getGroupRights(pk, rightType);
    }

    @Override
    public List<String> getReceiversAsUsers(FormPK pk, String rightType) throws FormsOnlineException {
        return this.getUserRights(pk, rightType);
    }

    @Override
    public List<String> getSendersAsGroups(FormPK pk) throws FormsOnlineException {
        return this.getGroupRights(pk, "S");
    }

    @Override
    public List<String> getSendersAsUsers(FormPK pk) throws FormsOnlineException {
        return this.getUserRights(pk, "S");
    }

    private List<String> getGroupRights(FormPK pk, String rightType) throws FormsOnlineException {
        ArrayList<String> groupsIds = new ArrayList<String>();
        try (Connection con = this.getConnection();
             PreparedStatement stmt = con.prepareStatement(QUERY_LOAD_GROUP_RIGHTS);){
            stmt.setString(1, pk.getInstanceId());
            stmt.setInt(2, Integer.parseInt(pk.getId()));
            stmt.setString(3, rightType);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    groupsIds.add(rs.getString("groupId"));
                }
            }
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"senders as users of form", (Object)pk.toString()), se);
        }
        return groupsIds;
    }

    private List<String> getUserRights(FormPK pk, String rightType) throws FormsOnlineException {
        ArrayList<String> userIds = new ArrayList<String>();
        try (Connection con = this.getConnection();
             PreparedStatement stmt = con.prepareStatement(QUERY_LOAD_USER_RIGHTS);){
            stmt.setString(1, pk.getInstanceId());
            stmt.setInt(2, Integer.parseInt(pk.getId()));
            stmt.setString(3, rightType);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    userIds.add(rs.getString("userId"));
                }
            }
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)("user rights (" + rightType + ") of form"), (Object)pk.toString()), se);
        }
        return userIds;
    }

    @Override
    public void updateReceivers(FormPK pk, Map<String, Pair<List<String>, List<String>>> userAndGroupIdsByRightTypes) throws FormsOnlineException {
        this.updateRights(pk, userAndGroupIdsByRightTypes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("S")));
    }

    @Override
    public void updateSenders(FormPK pk, Map<String, Pair<List<String>, List<String>>> userAndGroupIdsByRightTypes) throws FormsOnlineException {
        this.updateRights(pk, userAndGroupIdsByRightTypes.entrySet().stream().filter(e -> ((String)e.getKey()).equals("S")));
    }

    private void updateRights(FormPK pk, Stream<Map.Entry<String, Pair<List<String>, List<String>>>> userAndGroupIdsByRightTypes) throws FormsOnlineException {
        try (Connection con = this.getConnection();){
            userAndGroupIdsByRightTypes.forEach(e -> {
                try {
                    String rightType = (String)e.getKey();
                    this.removeGroupRights(con, pk, rightType);
                    this.removeUserRights(con, pk, rightType);
                    Pair ids = (Pair)e.getValue();
                    for (String newUserId : (List)ids.getFirst()) {
                        this.addUserRights(con, pk, newUserId, rightType);
                    }
                    for (String newGroupId : (List)ids.getSecond()) {
                        this.addGroupRights(con, pk, newGroupId, rightType);
                    }
                }
                catch (SQLException sqlE) {
                    throw new SilverpeasRuntimeException((Throwable)sqlE);
                }
            });
        }
        catch (Exception e2) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnUpdate((String)"user and group rights of form", (Object)pk.toString()), e2);
        }
    }

    private void addUserRights(Connection con, FormPK pk, String userId, String rightType) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_INSERT_USER_RIGHTS);){
            stmt.setInt(1, Integer.parseInt(pk.getId()));
            stmt.setString(2, pk.getInstanceId());
            stmt.setString(3, rightType);
            stmt.setString(4, userId);
            stmt.executeUpdate();
        }
    }

    private void addGroupRights(Connection con, FormPK pk, String groupId, String rightType) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_INSERT_GROUP_RIGHTS);){
            stmt.setInt(1, Integer.parseInt(pk.getId()));
            stmt.setString(2, pk.getInstanceId());
            stmt.setString(3, rightType);
            stmt.setString(4, groupId);
            stmt.executeUpdate();
        }
    }

    private void removeGroupRights(Connection con, FormPK pk, String rightType) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_REMOVE_GROUP_RIGHTS);){
            stmt.setString(1, pk.getInstanceId());
            stmt.setInt(2, Integer.parseInt(pk.getId()));
            stmt.setString(3, rightType);
            stmt.executeUpdate();
        }
    }

    private void removeUserRights(Connection con, FormPK pk, String rightType) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(QUERY_REMOVE_USER_RIGHTS);){
            stmt.setString(1, pk.getInstanceId());
            stmt.setInt(2, Integer.parseInt(pk.getId()));
            stmt.setString(3, rightType);
            stmt.executeUpdate();
        }
    }

    @Override
    public List<FormDetail> getUserAvailableForms(Collection<String> instanceIds, String userId, String[] userGroupIds, String orderBy) throws FormsOnlineException {
        try {
            ArrayList<FormDetail> forms = new ArrayList<FormDetail>();
            JdbcSqlQuery.executeBySplittingOn(instanceIds, (idBatch, ignore) -> {
                JdbcSqlQuery query = JdbcSqlQuery.select((String)"*").from(new String[]{FORMS_TABLENAME}).where(INSTANCE_ID, new Object[0]).in(instanceIds).and("(state = ?", new Object[]{1}).or("id in (select formId from SC_FormsOnline_FormInstances where creatorId = ?))", new Object[]{userId}).and("(id in (select formId from SC_FormsOnline_UserRights where rightType='S' and userId = ?)", new Object[]{userId});
                if (ArrayUtils.isNotEmpty((Object[])userGroupIds)) {
                    query.or("id in (select formId from SC_FormsOnline_GroupRights where rightType='S' and groupId", new Object[0]).in((Object[])userGroupIds).addSqlPart(")", new Object[0]);
                }
                query.addSqlPart(")", new Object[0]);
                query.orderBy(new String[]{orderBy});
                query.execute(r -> {
                    forms.add(this.fetchFormDetail((ResultSet)r));
                    return null;
                });
            });
            return forms;
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)("user (" + userId + ") available forms of instances"), (Object)String.join((CharSequence)",", instanceIds)), se);
        }
    }

    @Override
    public List<FormDetail> getForms(Collection<String> formIds) throws FormsOnlineException {
        ArrayList<FormDetail> forms = new ArrayList<FormDetail>();
        if (formIds == null || formIds.isEmpty()) {
            return forms;
        }
        StringBuilder query = new StringBuilder("SELECT * FROM SC_FormsOnline_Forms where id in (");
        int pos = 0;
        for (String formId : formIds) {
            if (pos++ != 0) {
                query.append(", ");
            }
            query.append(formId);
        }
        query.append(")");
        try (Connection con = this.getConnection();
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(query.toString());){
            while (rs.next()) {
                FormDetail form = this.fetchFormDetail(rs);
                forms.add(form);
            }
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"forms", (Object)String.join((CharSequence)",", formIds)), se);
        }
        return forms;
    }

    @Override
    public SilverpeasList<FormInstance> getSentFormInstances(FormPK pk, String userId, List<Integer> states, PaginationPage paginationPage) throws FormsOnlineException {
        return this.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds(pk.getInstanceId()).andFormIds(pk.getId()).andCreatorId(userId).andStates(states).paginateBy(paginationPage));
    }

    @Override
    public SilverpeasList<FormInstance> getReceivedRequests(FormDetail form, List<Integer> states, RequestValidationCriteria validationCriteria, PaginationPage paginationPage) throws FormsOnlineException {
        FormPK pk = form.getPK();
        return this.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds(pk.getInstanceId()).andValidationCriteria(validationCriteria).andFormIds(pk.getId()).andStates(states).paginateBy(paginationPage));
    }

    SilverpeasList<FormInstance> getRequestsByCriteria(RequestCriteria criteria) throws FormsOnlineException {
        SilverpeasList<FormInstance> silverpeasList;
        block14: {
            if (criteria.emptyResultWhenNoFilteringOnComponentInstances()) {
                return new SilverpeasArrayList(0);
            }
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"r.*").from(new String[]{"SC_FormsOnline_FormInstances r"}).where("instanceid", new Object[0]).in(criteria.getComponentInstanceIds());
            if (!criteria.getIds().isEmpty()) {
                query.and(ID, new Object[0]).in((Collection)criteria.getIds().stream().map(Integer::parseInt).collect(Collectors.toSet()));
            }
            if (!criteria.getFormIds().isEmpty()) {
                query.and(FORM_ID, new Object[0]).in((Collection)criteria.getFormIds().stream().map(Integer::parseInt).collect(Collectors.toSet()));
            }
            if (!criteria.getCreatorIds().isEmpty()) {
                query.and(CREATOR_ID, new Object[0]).in(criteria.getCreatorIds());
            }
            if (!criteria.getStates().isEmpty()) {
                query.and(STATE, new Object[0]).in(criteria.getStates());
            }
            this.applyValidationCriteria(criteria, query);
            List<RequestCriteria.QUERY_ORDER_BY> orderBies = criteria.getOrderByList().isEmpty() ? Arrays.asList(RequestCriteria.QUERY_ORDER_BY.CREATION_DATE_DESC, RequestCriteria.QUERY_ORDER_BY.ID_DESC) : criteria.getOrderByList();
            query.orderBy(new String[]{orderBies.stream().map(o -> o.getPropertyName() + " " + (o.isAsc() ? "asc" : "desc")).collect(Collectors.joining(","))});
            if (criteria.getPagination() != null) {
                query.withPagination(criteria.getPagination().asCriterion());
            }
            Connection connection = DBUtil.openConnection();
            try {
                ListSlice requests = query.executeWith(connection, this::fetchFormInstance);
                silverpeasList = this.decorateWithValidations(connection, (SilverpeasList<FormInstance>)requests);
                if (connection == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"form instance", (Object)criteria.toString()), e);
                }
            }
            connection.close();
        }
        return silverpeasList;
    }

    private void applyValidationCriteria(RequestCriteria criteria, JdbcSqlQuery query) {
        RequestValidationCriteria validationCriteria = criteria.getValidationCriteria();
        if (validationCriteria != null && !validationCriteria.isSkipValidationFiltering()) {
            String validatorId = validationCriteria.getValidatorId();
            if (validationCriteria.isInvert()) {
                query.and("NOT (", new Object[0]);
            } else {
                query.and("(", new Object[0]);
            }
            if (validationCriteria.isAvoidValidatedByValidator()) {
                query.addSqlPart("1 <> 1", new Object[0]);
            } else {
                query.addSqlPart(EXISTS_SELECT, new Object[0]).from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where(FORM_INST_ID_CLAUSE, new Object[0]).and("validationBy = ?)", new Object[]{validatorId});
            }
            if (validationCriteria.isStillNeedValidation()) {
                query.and("(1 <> 1", new Object[0]);
            }
            this.applyExclusiveValidationCriteria(query, validationCriteria);
            if (validationCriteria.isStillNeedValidation()) {
                query.addSqlPart(")", new Object[0]);
            }
            query.addSqlPart(")", new Object[0]);
        }
    }

    private void applyExclusiveValidationCriteria(JdbcSqlQuery query, RequestValidationCriteria validationCriteria) {
        validationCriteria.getOrLastValidationType().forEach(v -> {
            query.or("(", new Object[0]);
            query.addSqlPart(EXISTS_SELECT, new Object[0]).from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where(FORM_INST_ID_CLAUSE, new Object[0]).and("status = ?", new Object[]{ContributionStatus.VALIDATED}).and("validationType = ?)", new Object[]{v.name()});
            List nextValidationTypes = Stream.of(FormInstanceValidationType.values()).filter(e -> e.ordinal() > v.ordinal()).map(Enum::name).collect(Collectors.toList());
            if (!nextValidationTypes.isEmpty()) {
                query.and(NOT_EXISTS_SELECT, new Object[0]).from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where(FORM_INST_ID_CLAUSE, new Object[0]).and(VALIDATION_TYPE, new Object[0]).in(nextValidationTypes).addSqlPart(")", new Object[0]);
            }
            query.addSqlPart(")", new Object[0]);
        });
        if (validationCriteria.isOrNoValidator()) {
            query.or(NOT_EXISTS_SELECT, new Object[0]).from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where(FORM_INST_ID_CLAUSE, new Object[0]).addSqlPart(")", new Object[0]);
        }
        if (validationCriteria.isOrValidatorIsHierarchicalOne() && !validationCriteria.getManagedDomainUsers().isEmpty()) {
            query.or("(", new Object[0]);
            query.addSqlPart(CREATOR_ID, new Object[0]).in(validationCriteria.getManagedDomainUsers());
            query.and(NOT_EXISTS_SELECT, new Object[0]).from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where(FORM_INST_ID_CLAUSE, new Object[0]).addSqlPart(")", new Object[0]);
            query.addSqlPart(")", new Object[0]);
        }
    }

    private SilverpeasList<FormInstance> decorateWithValidations(Connection con, SilverpeasList<FormInstance> requests) throws SQLException {
        if (!requests.isEmpty()) {
            Mutable min = Mutable.of((Object)Integer.MAX_VALUE);
            Mutable max = Mutable.of((Object)Integer.MIN_VALUE);
            Map<Integer, FormInstance> indexedById = requests.stream().map(i -> {
                int idAsInt = i.getIdAsInt();
                min.set((Object)Math.min((Integer)min.get(), idAsInt));
                max.set((Object)Math.max((Integer)max.get(), idAsInt));
                return i;
            }).collect(Collectors.toMap(FormInstance::getIdAsInt, r -> r));
            JdbcSqlQuery.select((String)"*").from(new String[]{FORMS_INSTANCE_VALIDATIONS_TABLENAME}).where("formInstId BETWEEN ? AND ?", new Object[]{min.get(), max.get()}).executeWith(con, r -> {
                FormInstance request = (FormInstance)indexedById.get(r.getInt(FORM_INST_ID));
                if (request != null) {
                    FormInstanceValidation validation = new FormInstanceValidation(request);
                    validation.setId(r.getInt(ID));
                    validation.setStatus(ContributionStatus.valueOf((String)r.getString("status")));
                    validation.setComment(r.getString("validationComment"));
                    validation.setValidationBy(r.getString(VALIDATION_BY));
                    validation.setDate(r.getTimestamp("validationDate"));
                    validation.setValidationType(FormInstanceValidationType.valueOf(r.getString(VALIDATION_TYPE)));
                    validation.setFollower(r.getBoolean("follower"));
                    request.getValidations().add(validation);
                }
                return null;
            });
        }
        return requests;
    }

    @Override
    public Map<String, Set<FormInstanceValidationType>> getValidatorFormIdsWithValidationTypes(String instanceId, String validatorId, String[] validatorGroupIds, Collection<String> formIds) throws FormsOnlineException {
        HashMap<String, Set<FormInstanceValidationType>> result = new HashMap<String, Set<FormInstanceValidationType>>();
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"DISTINCT formId, rightType").from(new String[]{USER_RIGHTS_TABLENAME}).join("SC_FormsOnline_Forms f").on("f.id = formId", new Object[0]).where("f.instanceId = ?", new Object[]{instanceId}).and(RIGHT_TYPE, new Object[0]).in(new Object[]{"I", "R"}).and("userId = ?", new Object[]{validatorId});
        if (CollectionUtil.isNotEmpty(formIds)) {
            query.and(FORM_ID, new Object[0]).in((Collection)formIds.stream().map(Integer::parseInt).collect(Collectors.toSet()));
        }
        if (ArrayUtils.isNotEmpty((Object[])validatorGroupIds)) {
            query.union().addSqlPart("SELECT DISTINCT formId, rightType", new Object[0]).from(new String[]{GROUP_RIGHTS_TABLENAME}).join("SC_FormsOnline_Forms f").on("f.id = formId", new Object[0]).where("f.instanceId = ?", new Object[]{instanceId}).and(RIGHT_TYPE, new Object[0]).in(new Object[]{"I", "R"}).and("groupId", new Object[0]).in((Object[])validatorGroupIds);
            if (CollectionUtil.isNotEmpty(formIds)) {
                query.and(FORM_ID, new Object[0]).in((Collection)formIds.stream().map(Integer::parseInt).collect(Collectors.toSet()));
            }
        }
        try {
            query.execute(this.fetchRightValidationTypesByForm(result));
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)("user (" + validatorId + ") available form as receiver ids of instance"), (Object)instanceId), se);
        }
        return result;
    }

    @Override
    public Map<String, Set<FormInstanceValidationType>> getPossibleValidationTypesByFormId(Collection<String> formIds) throws FormsOnlineException {
        HashMap<String, Set<FormInstanceValidationType>> result = new HashMap<String, Set<FormInstanceValidationType>>();
        if (!formIds.isEmpty()) {
            Collection asIntegers = formIds.stream().map(Integer::parseInt).collect(Collectors.toSet());
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"formId, rightType").from(new String[]{USER_RIGHTS_TABLENAME}).join(FORMS_TABLENAME).on("id = formId", new Object[0]).where(RIGHT_TYPE, new Object[0]).in(new Object[]{"I", "R"}).and(FORM_ID, new Object[0]).in(asIntegers);
            query.union().addSqlPart("SELECT formId, rightType", new Object[0]).from(new String[]{GROUP_RIGHTS_TABLENAME}).join(FORMS_TABLENAME).on("id = formId", new Object[0]).where(RIGHT_TYPE, new Object[0]).in(new Object[]{"I", "R"}).and(FORM_ID, new Object[0]).in(asIntegers);
            query.union().addSqlPart("SELECT id AS formId, 'H'", new Object[0]).from(new String[]{FORMS_TABLENAME}).where(ID, new Object[0]).in(asIntegers).and("hierarchicalValidation = ?", new Object[]{true});
            try {
                query.execute(this.fetchRightValidationTypesByForm(result));
            }
            catch (SQLException se) {
                throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"possible rights on", formIds), se);
            }
        }
        return result;
    }

    private SelectResultRowProcess<Object> fetchRightValidationTypesByForm(Map<String, Set<FormInstanceValidationType>> result) {
        return r -> {
            String formId = String.valueOf(r.getInt(FORM_ID));
            String rightValidatorType = r.getString(RIGHT_TYPE);
            result.computeIfAbsent(formId, s -> new TreeSet()).add(FormInstanceValidationType.fromRightsCode(rightValidatorType));
            return null;
        };
    }

    private FormDetail fetchFormDetail(ResultSet rs) throws SQLException {
        FormDetail form = new FormDetail();
        form.setId(rs.getInt(ID));
        form.setXmlFormName(rs.getString("xmlFormName"));
        form.setName(rs.getString("name"));
        form.setDescription(rs.getString("description"));
        form.setTitle(rs.getString("title"));
        form.setCreatorId(rs.getString(CREATOR_ID));
        form.setCreationDate(rs.getTimestamp(CREATION_DATE));
        form.setInstanceId(rs.getString(INSTANCE_ID));
        form.setState(rs.getInt(STATE));
        form.setHierarchicalValidation(rs.getBoolean("hierarchicalValidation"));
        form.setRequestExchangeReceiver(rs.getString("formInstExchangeReceiver"));
        form.setDeleteAfterRequestExchange(rs.getBoolean("deleteAfterFormInstExchange"));
        return form;
    }

    @Override
    public FormInstance saveRequest(FormInstance request) throws FormsOnlineException {
        boolean isInsert = !JdbcSqlQuery.isSqlDefined((String)request.getId());
        try {
            JdbcSqlQuery formInstanceSave;
            int formInstId;
            JdbcSqlQueries saveQueries = new JdbcSqlQueries();
            if (isInsert) {
                formInstId = DBUtil.getNextId((String)FORMS_INSTANCES_TABLENAME, (String)ID);
                request.setId(formInstId);
                formInstanceSave = JdbcSqlQuery.insertInto((String)FORMS_INSTANCES_TABLENAME);
                formInstanceSave.withInsertParam(ID, (Object)formInstId);
            } else {
                formInstId = request.getIdAsInt();
                formInstanceSave = JdbcSqlQuery.update((String)FORMS_INSTANCES_TABLENAME);
            }
            saveQueries.add((Object)formInstanceSave);
            formInstanceSave.withSaveParam(FORM_ID, (Object)request.getFormId(), isInsert);
            formInstanceSave.withSaveParam(STATE, (Object)request.getState(), isInsert);
            formInstanceSave.withSaveParam(INSTANCE_ID, (Object)request.getComponentInstanceId(), isInsert);
            if (isInsert) {
                formInstanceSave.withSaveParam(CREATOR_ID, (Object)request.getCreatorId(), true);
                formInstanceSave.withSaveParam(CREATION_DATE, (Object)Timestamp.from(Instant.now()), true);
            } else {
                if (request.getState() <= 1) {
                    formInstanceSave.withSaveParam(CREATION_DATE, (Object)Timestamp.from(Instant.now()), false);
                }
                formInstanceSave.where(ID_CRITERIA, new Object[]{formInstId});
            }
            saveQueries.addAll(this.prepareSaveValidations(request.getValidations()));
            saveQueries.execute();
            return request;
        }
        catch (Exception e) {
            String idAsString = String.valueOf(request.getFormId());
            if (isInsert) {
                throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnAdding((String)REQUEST_MSG, (Object)idAsString), e);
            }
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnUpdate((String)REQUEST_MSG, (Object)idAsString), e);
        }
    }

    private List<JdbcSqlQuery> prepareSaveValidations(Collection<FormInstanceValidation> validations) {
        return validations.stream().map(v -> {
            JdbcSqlQuery validationSave;
            int validationId;
            boolean isInsert;
            boolean bl = isInsert = v.getId() == null || v.getId() == -1;
            if (isInsert) {
                validationId = DBUtil.getNextId((String)FORMS_INSTANCE_VALIDATIONS_TABLENAME, (String)ID);
                v.setId(validationId);
                validationSave = JdbcSqlQuery.insertInto((String)FORMS_INSTANCE_VALIDATIONS_TABLENAME);
                validationSave.withInsertParam(ID, (Object)validationId);
            } else {
                validationId = v.getId();
                validationSave = JdbcSqlQuery.update((String)FORMS_INSTANCE_VALIDATIONS_TABLENAME);
            }
            validationSave.withSaveParam(FORM_INST_ID, (Object)v.getFormInstance().getIdAsInt(), isInsert);
            validationSave.withSaveParam(VALIDATION_BY, (Object)v.getValidator().getId(), isInsert);
            validationSave.withSaveParam(VALIDATION_TYPE, (Object)v.getValidationType().name(), isInsert);
            validationSave.withSaveParam("status", (Object)v.getStatus().name(), isInsert);
            validationSave.withSaveParam("validationComment", (Object)v.getComment(), isInsert);
            validationSave.withSaveParam("follower", (Object)v.isFollower(), isInsert);
            if (isInsert) {
                Timestamp validationDate = v.getDate() != null ? new Timestamp(v.getDate().getTime()) : Timestamp.from(Instant.now());
                validationSave.withSaveParam("validationDate", (Object)validationDate, true);
            } else {
                validationSave.where(ID_CRITERIA, new Object[]{validationId});
            }
            return validationSave;
        }).collect(Collectors.toList());
    }

    @Override
    public void saveRequestState(FormInstance request) throws FormsOnlineException {
        try {
            if (!JdbcSqlQuery.isSqlDefined((String)request.getId())) {
                throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnUpdate((String)REQUEST_MSG, (Object)request.getFormId()), new String[0]);
            }
            Transaction.performInOne(() -> {
                JdbcSqlQuery formInstanceStateSave = JdbcSqlQuery.update((String)FORMS_INSTANCES_TABLENAME);
                formInstanceStateSave.withUpdateParam(STATE, (Object)request.getState());
                formInstanceStateSave.where(ID_CRITERIA, new Object[]{request.getIdAsInt()});
                return formInstanceStateSave.execute();
            });
        }
        catch (Exception e) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnUpdate((String)"instance state on form", (Object)request.getFormId()), e);
        }
    }

    @Override
    public FormInstance getRequest(RequestPK pk) throws FormsOnlineException {
        return (FormInstance)JdbcSqlQuery.unique(this.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds(pk.getInstanceId()).andIds(pk.getId())));
    }

    @Override
    public void deleteRequest(RequestPK pk) throws FormsOnlineException {
        try {
            JdbcSqlQueries deleteQueries = new JdbcSqlQueries();
            deleteQueries.add((Object)JdbcSqlQuery.deleteFrom((String)FORMS_INSTANCE_VALIDATIONS_TABLENAME).where("formInstId = ?", new Object[]{Integer.parseInt(pk.getId())}));
            deleteQueries.add((Object)JdbcSqlQuery.deleteFrom((String)FORMS_INSTANCES_TABLENAME).where("instanceId = ?", new Object[]{pk.getInstanceId()}).and(ID_CRITERIA, new Object[]{Integer.parseInt(pk.getId())}));
            deleteQueries.execute();
        }
        catch (Exception e) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnDeleting((String)"form instance", (Object)pk.toString()), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Integer, Integer> getNumberOfRequestsByForm(String instanceId) throws FormsOnlineException {
        try (Connection con = this.getConnection();){
            HashMap<Integer, Integer> hashMap;
            block22: {
                PreparedStatement stmt = con.prepareStatement(COUNT_REQUESTS_BY_FORM);
                try {
                    stmt.setString(1, instanceId);
                    HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            map.put(rs.getInt(1), rs.getInt(2));
                        }
                    }
                    hashMap = map;
                    if (stmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return hashMap;
        }
        catch (SQLException se) {
            throw new FormsOnlineException(SilverpeasExceptionMessages.failureOnGetting((String)"number of instance by form of component instance", (Object)instanceId), se);
        }
    }

    @Override
    public SilverpeasList<FormInstance> getAllRequests(FormPK pk) throws FormsOnlineException {
        return this.getRequestsByCriteria(RequestCriteria.onComponentInstanceIds(pk.getInstanceId()).andFormIds(pk.getId()));
    }

    private FormInstance fetchFormInstance(ResultSet rs) throws SQLException {
        FormInstance formInstance = new FormInstance();
        formInstance.setId(rs.getInt(ID));
        formInstance.setFormId(rs.getInt(FORM_ID));
        formInstance.setState(rs.getInt(STATE));
        formInstance.setCreatorId(rs.getString(CREATOR_ID));
        formInstance.setCreationDate(rs.getTimestamp(CREATION_DATE));
        formInstance.setInstanceId(rs.getString(INSTANCE_ID));
        return formInstance;
    }

    protected Connection getConnection() throws SQLException {
        return DBUtil.openConnection();
    }

    private static void prepareDateStatement(PreparedStatement stat, int pos, Date dateValue) throws SQLException {
        if (dateValue == null) {
            stat.setNull(pos, 91);
        } else {
            stat.setTimestamp(pos, new Timestamp(dateValue.getTime()));
        }
    }
}

