/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.annotation.Nonnull;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.core.clipboard.ClipboardSelection;
import org.silverpeas.core.clipboard.SKDException;
import org.silverpeas.core.clipboard.SilverpeasKeyData;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.kernel.logging.SilverLogger;

public class MediaSelection
extends ClipboardSelection {
    private static final long serialVersionUID = -4373774805830276786L;
    private final Media currentMedia;
    public static final DataFlavor MediaFlavor = new DataFlavor(Media.class, "Media");

    public MediaSelection(Media media) {
        this.currentMedia = media;
        super.addFlavor(MediaFlavor);
    }

    @Nonnull
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
        Object transferedData;
        try {
            transferedData = super.getTransferData(parFlavor);
        }
        catch (UnsupportedFlavorException e) {
            if (MediaFlavor.equals(parFlavor)) {
                transferedData = this.currentMedia;
            }
            throw e;
        }
        return transferedData;
    }

    public IndexEntry getIndexEntry() {
        MediaPK mediaPK = this.currentMedia.getMediaPK();
        IndexEntry indexEntry = new IndexEntry(new IndexEntryKey(mediaPK.getComponentName(), this.currentMedia.getType().name(), this.currentMedia.getMediaPK().getId()));
        indexEntry.setTitle(this.currentMedia.getName());
        return indexEntry;
    }

    public SilverpeasKeyData getKeyData() {
        SilverpeasKeyData keyData = new SilverpeasKeyData();
        keyData.setTitle(this.currentMedia.getName());
        keyData.setAuthor(this.currentMedia.getCreatorId());
        keyData.setCreationDate(this.currentMedia.getCreationDate());
        keyData.setDesc(this.currentMedia.getDescription());
        try {
            if (this.currentMedia.getVisibilityPeriod().getBeginDatable().isDefined()) {
                keyData.setProperty("BEGINDATE", this.currentMedia.getVisibilityPeriod().getBeginDate().toString());
            }
            if (this.currentMedia.getVisibilityPeriod().getEndDatable().isDefined()) {
                keyData.setProperty("ENDDATE", this.currentMedia.getVisibilityPeriod().getEndDate().toString());
            }
        }
        catch (SKDException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
        }
        return keyData;
    }
}

