/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.rssaggregator.model;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndImage;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.rssaggregator.model.SPChannel;
import org.silverpeas.kernel.annotation.NonNull;

public class RSSItem
implements Comparable<RSSItem> {
    private final String itemTitle;
    private final String itemDescription;
    private final String itemLink;
    private final Date itemDate;
    private final Long channelId;
    private final String channelTitle;
    private final SyndImage channelImage;

    public RSSItem(SyndEntry item, SyndFeed feed, SPChannel spChannel) {
        this.itemTitle = item.getTitle();
        this.itemDescription = item.getDescription() != null ? item.getDescription().getValue() : null;
        this.itemLink = item.getLink() == null ? item.getUri() : item.getLink();
        this.itemDate = item.getUpdatedDate() == null ? item.getPublishedDate() : item.getUpdatedDate();
        this.channelTitle = feed.getTitle();
        this.channelImage = feed.getImage();
        this.channelId = Long.parseLong(spChannel.getPK().getId());
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public String getItemLink() {
        return this.itemLink;
    }

    public Date getItemDate() {
        return this.itemDate != null ? (Date)this.itemDate.clone() : null;
    }

    public String getChannelTitle() {
        return this.channelTitle;
    }

    public SyndImage getChannelImage() {
        return this.channelImage;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    @Override
    public int compareTo(@NonNull RSSItem other) {
        if (this.getItemDate() != null && other.getItemDate() != null) {
            return other.getItemDate().compareTo(this.getItemDate());
        }
        if (this.getItemDate() == null && other.getItemDate() != null) {
            return 1;
        }
        if (this.getItemDate() != null && other.getItemDate() == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RSSItem)) {
            return false;
        }
        RSSItem rssItem = (RSSItem)o;
        if (!Objects.equals(this.itemTitle, rssItem.itemTitle)) {
            return false;
        }
        if (!Objects.equals(this.channelId, rssItem.channelId)) {
            return false;
        }
        return this.compareTo(rssItem) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.itemTitle).append((Object)this.channelId).append((Object)this.itemDate).toHashCode();
    }
}

