/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.repository;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.model.SuggestionCriteria;
import org.silverpeas.components.suggestionbox.repository.JPQLQueryBuilder;
import org.silverpeas.components.suggestionbox.repository.SuggestionJPARepository;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.AbstractJpaEntity;
import org.silverpeas.core.persistence.datasource.repository.EntityRepository;
import org.silverpeas.core.persistence.datasource.repository.QueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;

@Repository
public class SuggestionRepository
implements EntityRepository<Suggestion> {
    @Inject
    private CommentService commentService;
    @Inject
    SuggestionJPARepository suggestionManager;

    public static SuggestionRepository get() {
        return (SuggestionRepository)ServiceProvider.getService(SuggestionRepository.class, (Annotation[])new Annotation[0]);
    }

    public List<Suggestion> findByCriteria(SuggestionCriteria criteria) {
        NamedParameters params = this.suggestionManager.newNamedParameters();
        JPQLQueryBuilder queryBuilder = new JPQLQueryBuilder(params);
        criteria.processWith(queryBuilder);
        SilverpeasList suggestions = this.suggestionManager.findByCriteria(queryBuilder.result());
        return this.decorate((List<Suggestion>)suggestions, criteria);
    }

    public SilverpeasList<Suggestion> getAll() {
        return this.decorate((List<Suggestion>)this.suggestionManager.getAll(), SuggestionCriteria.from(null).withWysiwygContent());
    }

    public Suggestion getById(String id) {
        return this.decorate((Suggestion)this.suggestionManager.getById(id), SuggestionCriteria.from(null).withWysiwygContent());
    }

    public SilverpeasList<Suggestion> getById(Collection<String> ids) {
        return this.decorate((List<Suggestion>)this.suggestionManager.getById(ids), SuggestionCriteria.from(null).withWysiwygContent());
    }

    public SilverpeasList<Suggestion> findByCriteria(QueryCriteria criteria) {
        return this.decorate((List<Suggestion>)this.suggestionManager.findByCriteria(criteria), SuggestionCriteria.from(null).withWysiwygContent());
    }

    public Suggestion save(Suggestion suggestion) {
        this.suggestionManager.save((IdentifiableEntity)suggestion);
        this.suggestionManager.flush();
        if (suggestion.isContentModified()) {
            WysiwygController.save((String)suggestion.getContent(), (String)suggestion.getSuggestionBox().getComponentInstanceId(), (String)suggestion.getId(), (String)suggestion.getLastUpdaterId(), null, (boolean)false);
        }
        return suggestion;
    }

    public SilverpeasList<Suggestion> save(Suggestion ... suggestions) {
        return this.save(Arrays.asList(suggestions));
    }

    public SilverpeasList<Suggestion> save(List<Suggestion> suggestions) {
        for (Suggestion suggestion : suggestions) {
            this.save(suggestion);
        }
        return SilverpeasList.wrap(suggestions);
    }

    public void delete(Suggestion ... suggestions) {
        this.delete(Arrays.asList(suggestions));
    }

    public void delete(List<Suggestion> suggestions) {
        this.suggestionManager.delete(suggestions);
        this.suggestionManager.flush();
        for (Suggestion suggestion : suggestions) {
            WysiwygController.deleteWysiwygAttachments((String)suggestion.getComponentInstanceId(), (String)suggestion.getId());
            this.commentService.deleteAllCommentsOnResource(suggestion.getContributionType(), new ResourceReference(suggestion.getId(), suggestion.getComponentInstanceId()));
        }
    }

    public long deleteById(String ... ids) {
        return this.deleteById(Arrays.asList(ids));
    }

    public long deleteById(Collection<String> ids) {
        SilverpeasList suggestions = this.suggestionManager.getById(ids);
        this.delete((List<Suggestion>)suggestions);
        return suggestions.size();
    }

    public void flush() {
        this.suggestionManager.flush();
    }

    public boolean contains(Suggestion entity) {
        return this.suggestionManager.contains((AbstractJpaEntity)entity);
    }

    private Suggestion decorate(Suggestion suggestion, SuggestionCriteria criteria) {
        if (criteria.mustLoadWysiwygContent()) {
            this.withContent(suggestion);
        }
        this.withCommentCount(suggestion);
        suggestion.setRating(RatingService.get().getRating((SilverpeasContent)suggestion));
        return suggestion;
    }

    private SilverpeasList<Suggestion> decorate(List<Suggestion> suggestions, SuggestionCriteria criteria) {
        Map suggestionRatings = RatingService.get().getRatings(suggestions.toArray(new SilverpeasContent[0]));
        for (Suggestion suggestion : suggestions) {
            if (criteria.mustLoadWysiwygContent()) {
                this.withContent(suggestion);
            }
            this.withCommentCount(suggestion);
            suggestion.setRating((ContributionRating)suggestionRatings.get(suggestion.getId()));
        }
        return SilverpeasList.wrap(suggestions);
    }

    private void withContent(Suggestion suggestion) {
        if (suggestion != null) {
            String content = WysiwygController.load((String)suggestion.getSuggestionBox().getComponentInstanceId(), (String)suggestion.getId(), null);
            suggestion.setContent(content);
        }
    }

    private void withCommentCount(Suggestion suggestion) {
        if (suggestion != null) {
            int count = this.commentService.getCommentsCountOnResource(suggestion.getContributionType(), new ResourceReference(suggestion.getId(), suggestion.getComponentInstanceId()));
            suggestion.setCommentCount(count);
        }
    }

    public void index(Suggestion suggestion) {
        if (suggestion != null && suggestion.getValidation().isValidated()) {
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(suggestion.getComponentInstanceId(), "Suggestion", suggestion.getId()));
            indexEntry.setTitle(suggestion.getTitle());
            indexEntry.setCreationDate(suggestion.getValidation().getDate());
            indexEntry.setCreationUser(suggestion.getCreatorId());
            WysiwygController.addToIndex((FullIndexEntry)indexEntry, (ResourceReference)new ResourceReference(suggestion.getId(), suggestion.getComponentInstanceId()), null);
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }
}

