/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.notification;

import javax.inject.Named;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.notification.SuggestionNotifyManuallyUserNotification;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;

@Named
public class SuggestionBoxInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    private static final String SUGGESTION_KEY = "SuggestionBoxKey";

    protected boolean check(NotificationContext context) {
        String boxId = context.getComponentId();
        String suggestionId = context.getContributionId();
        SuggestionBox box = SuggestionBox.getByComponentInstanceId(boxId);
        Suggestion suggestion = box.getSuggestions().get(suggestionId);
        context.put((Object)SUGGESTION_KEY, (Object)suggestion);
        return suggestion.canBeAccessedBy(context.getSender());
    }

    public UserNotification createUserNotification(NotificationContext context) {
        Suggestion suggestion = (Suggestion)((Object)context.getObject((Object)SUGGESTION_KEY));
        return new SuggestionNotifyManuallyUserNotification(suggestion, context.getSender()).build();
    }
}

