/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.Locale;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.ParagraphProperties;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.style.TextProperties;
import org.odftoolkit.simple.text.Paragraph;

public class ParagraphStyleHandler
extends DefaultStyleHandler {
    TextParagraphElementBase mParaElement;

    ParagraphStyleHandler(Paragraph aParagraph) {
        super((OdfStylableElement)aParagraph.getOdfElement());
        this.mParaElement = aParagraph.getOdfElement();
    }

    public String getCountry(Document.ScriptType type) {
        String country = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        if (textProperties != null) {
            country = textProperties.getCountry(type);
        }
        if (country != null && country.length() > 0) {
            return country;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            country = parentStyleSetting.getCountry(type);
            if (country != null && country.length() > 0) {
                return country;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getParagraphDefaultStyle();
            TextProperties defaultStyleSetting = TextProperties.getTextProperties((OdfStyleBase)defaultStyle);
            country = defaultStyleSetting.getCountry(type);
        }
        return country;
    }

    public Font getFont(Document.ScriptType type) {
        Font font = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        font = textProperties != null ? textProperties.getFont(type) : new Font(null, null, 0.0, (StyleTypeDefinitions.TextLinePosition)null);
        if (font != null && font.getFamilyName() != null && font.getColor() != null && font.getSize() != 0.0 && font.getFontStyle() != null && font.getTextLinePosition() != null) {
            return font;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            if (parentStyleSetting != null) {
                Font tempFont = parentStyleSetting.getFont(type);
                this.mergeFont(font, tempFont);
                if (font.getFamilyName() != null && font.getColor() != null && font.getSize() > 0.0 && font.getFontStyle() != null && font.getTextLinePosition() != null) {
                    return font;
                }
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getParagraphDefaultStyle();
            if (defaultStyle == null) {
                defaultStyle = this.getParagraphDefaultStyle();
            }
            if (defaultStyle != null) {
                TextProperties defaultStyleSetting = TextProperties.getTextProperties((OdfStyleBase)defaultStyle);
                Font tempFont = defaultStyleSetting.getFont(type);
                this.mergeFont(font, tempFont);
            }
        }
        if (font.getColor() == null) {
            font.setColor(Color.BLACK);
        }
        if (font.getFontStyle() == null) {
            font.setFontStyle(StyleTypeDefinitions.FontStyle.REGULAR);
        }
        if (font.getTextLinePosition() == null) {
            font.setTextLinePosition(StyleTypeDefinitions.TextLinePosition.REGULAR);
        }
        return font;
    }

    public String getLanguage(Document.ScriptType type) {
        String language = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        if (textProperties != null) {
            language = textProperties.getLanguage(type);
        }
        if (language != null && language.length() > 0) {
            return language;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            language = parentStyleSetting.getLanguage(type);
            if (language != null && language.length() > 0) {
                return language;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getParagraphDefaultStyle();
            TextProperties defaultStyleSetting = TextProperties.getTextProperties((OdfStyleBase)defaultStyle);
            language = defaultStyleSetting.getLanguage(type);
        }
        return language;
    }

    public void setCountry(String country, Document.ScriptType type) {
        this.getTextPropertiesForWrite().setCountry(country, type);
    }

    public void setFont(Font font) {
        this.getTextPropertiesForWrite().setFont(font);
    }

    public void setFont(Font font, Locale language) {
        this.getTextPropertiesForWrite().setFont(font, language);
    }

    public void setLanguage(String language, Document.ScriptType type) {
        this.getTextPropertiesForWrite().setLanguage(language, type);
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        this.getParagraphPropertiesForWrite().setHorizontalAlignment(alignType);
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignment() {
        StyleTypeDefinitions.HorizontalAlignmentType tempAlign = null;
        ParagraphProperties properties = this.getParagraphPropertiesForRead();
        if (properties != null) {
            tempAlign = properties.getHorizontalAlignment();
        }
        if (tempAlign != null) {
            return tempAlign;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            ParagraphProperties parentStyleSetting = ParagraphProperties.getParagraphProperties(parentStyle);
            tempAlign = parentStyleSetting.getHorizontalAlignment();
            if (tempAlign != null) {
                return tempAlign;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getParagraphDefaultStyle();
            ParagraphProperties defaultStyleSetting = ParagraphProperties.getParagraphProperties((OdfStyleBase)defaultStyle);
            tempAlign = defaultStyleSetting.getHorizontalAlignment();
        }
        if (tempAlign == null) {
            return StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT;
        }
        return tempAlign;
    }

    private OdfDefaultStyle getParagraphDefaultStyle() {
        return this.mDocument.getDocumentStyles().getDefaultStyle(OdfStyleFamily.Paragraph);
    }

    private OdfStyleBase getParentStyle(OdfStyle aStyle) {
        String parentName = aStyle.getStyleParentStyleNameAttribute();
        if (parentName == null || parentName.length() == 0) {
            return null;
        }
        if (parentName.equals("Default")) {
            return this.getParagraphDefaultStyle();
        }
        return this.getStyleByName(parentName);
    }

    private OdfStyle getStyleByName(String name) {
        OdfStyle styleElement = null;
        OdfOfficeAutomaticStyles styles = this.mParaElement.getAutomaticStyles();
        styleElement = styles.getStyle(name, OdfStyleFamily.Paragraph);
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(name, OdfStyleFamily.Paragraph);
        }
        return styleElement;
    }

    private OdfStyleBase getCurrentUsedStyle() {
        if (this.mWritableStyleElement != null) {
            return this.mWritableStyleElement;
        }
        return this.mStyleElement;
    }

    private void mergeFont(Font target, Font source) {
        if (target.getFamilyName() == null && source.getFamilyName() != null) {
            target.setFamilyName(source.getFamilyName());
        }
        if (target.getColor() == null && source.getColor() != null) {
            target.setColor(source.getColor());
        }
        if (target.getSize() == 0.0 && source.getSize() > 0.0) {
            target.setSize(source.getSize());
        }
        if (target.getFontStyle() == null && source.getFontStyle() != null) {
            target.setFontStyle(source.getFontStyle());
        }
        if (target.getTextLinePosition() == null && source.getTextLinePosition() != null) {
            target.setTextLinePosition(source.getTextLinePosition());
        }
    }
}

