/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import java.util.Optional;
import javax.inject.Inject;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.repository.CommunityMembershipRepository;
import org.silverpeas.components.community.repository.CommunityOfUsersRepository;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.notification.SpaceEvent;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
class CommunitySpaceRemovingListener
extends CDIResourceEventListener<SpaceEvent> {
    @Inject
    private Administration administration;
    @Inject
    private CommunityOfUsersRepository communityRepository;
    @Inject
    private CommunityMembershipRepository membershipRepository;

    CommunitySpaceRemovingListener() {
    }

    public void onRemoving(SpaceEvent event) {
        SpaceInst space = (SpaceInst)event.getTransition().getBefore();
        Optional<CommunityOfUsers> community = CommunityOfUsers.getBySpaceId(space.getId());
        community.filter(c -> c.groupId != null).ifPresent(c -> {
            String groupId = String.valueOf(c.groupId);
            c.groupId = null;
            Transaction.performInOne(() -> {
                this.communityRepository.save((IdentifiableEntity)c);
                this.communityRepository.flush();
                this.membershipRepository.getMembershipsTable((CommunityOfUsers)((Object)c)).deleteAll();
                this.administration.deleteGroupById(groupId, true);
                return null;
            });
        });
    }
}

