/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class SameNodeImpl
extends ConstraintImpl {
    private final String path;
    private final String selectorName;
    private SelectorImpl selector;

    public SameNodeImpl(String selectorName, String path) {
        this.selectorName = selectorName;
        this.path = path;
    }

    @Override
    public boolean evaluate() {
        String p = this.normalizePath(this.path);
        return this.selector.currentPath().equals(p);
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "issamenode(" + this.quote(this.selectorName) + ", " + this.quote(this.path) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            String p = this.normalizePath(this.path);
            f.restrictPath(p, Filter.PathRestriction.EXACT);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public AstElement copyOf() {
        return new SameNodeImpl(this.selectorName, this.path);
    }
}

