/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.survey.notification;

import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerService;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractSurveyUserNotification
extends AbstractTemplateUserNotificationBuilder<QuestionContainerDetail> {
    private final User sender;

    AbstractSurveyUserNotification(QuestionContainerDetail surveyDetail, User sender) {
        super((Object)surveyDetail);
        this.sender = sender;
    }

    protected void performTemplateData(String language, QuestionContainerDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("UserDetail", (Object)this.sender);
        template.setAttribute("userName", (Object)(this.sender != null ? this.sender.getDisplayedName() : ""));
        template.setAttribute("SurveyDetail", (Object)resource);
        template.setAttribute("surveyName", (Object)Encode.forHtml((String)resource.getHeader().getName()));
        String surveyDesc = resource.getHeader().getDescription();
        if (StringUtil.isDefined((String)surveyDesc)) {
            template.setAttribute("surveyDesc", (Object)Encode.forHtml((String)surveyDesc));
        }
        String pathToSurvey = QuestionContainerService.get().getHTMLQuestionPath(resource);
        template.setAttribute("htmlPath", (Object)pathToSurvey);
    }

    protected void performNotificationResource(String language, QuestionContainerDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getHeader().getName());
    }

    protected String getTemplatePath() {
        return "survey";
    }

    protected NotifAction getAction() {
        return NotifAction.REPORT;
    }

    protected String getComponentInstanceId() {
        return ((QuestionContainerDetail)this.getResource()).getComponentInstanceId();
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.survey.multilang.surveyBundle";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "survey.notifSurveyLinkLabel";
    }
}

