/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final Version i = new Version();
    private final String name;
    private final String version;

    public static Version get() {
        return i;
    }

    public Version() {
        String _version;
        String _name;
        Properties props = new Properties();
        try {
            props.load(Version.class.getResourceAsStream("/library.properties"));
            _name = props.getProperty("library.name");
            _version = props.getProperty("library.version");
        }
        catch (IOException ex) {
            log.error("Error loading version info from library.properties", (Throwable)ex);
            _name = "Unknown";
            _version = "Unknown";
        }
        this.name = _name;
        this.version = _version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }
}

