/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.authorization.PrivilegeCollection;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.jetbrains.annotations.NotNull;

abstract class AbstractPrivilegeCollection
implements PrivilegeCollection {
    private final PrivilegeBits privilegeBits;

    AbstractPrivilegeCollection(@NotNull PrivilegeBits privilegeBits) {
        this.privilegeBits = privilegeBits;
    }

    @NotNull
    abstract PrivilegeBitsProvider getPrivilegeBitsProvider();

    @NotNull
    abstract NamePathMapper getNamePathMapper();

    public boolean includes(String ... privilegeNames) throws RepositoryException {
        if (privilegeNames.length == 0) {
            return true;
        }
        if (this.privilegeBits.isEmpty()) {
            return false;
        }
        PrivilegeBits toTest = this.getPrivilegeBitsProvider().getBits(PrivilegeUtil.getOakNames(privilegeNames, this.getNamePathMapper()), true);
        return this.privilegeBits.includes(toTest);
    }

    public int hashCode() {
        return Objects.hashCode(this.privilegeBits);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractPrivilegeCollection) {
            AbstractPrivilegeCollection other = (AbstractPrivilegeCollection)obj;
            return this.privilegeBits.equals(other.privilegeBits);
        }
        return false;
    }
}

