/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.simple.style.Border;

class BorderPropertiesImpl {
    OdfStylePropertiesBase borderPropertiesElement;

    public BorderPropertiesImpl(OdfStylePropertiesBase element) {
        this.borderPropertiesElement = element;
    }

    public void setBottomBorder(Border border) {
        if (border == null) {
            this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthBottomAttribute.ATTRIBUTE_NAME.getQName());
            this.borderPropertiesElement.removeAttribute(FoBorderBottomAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:border-line-width-bottom", border.getDoubleLineWidthDescription());
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-bottom", border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-bottom", border.getBorderDescription());
                break;
            }
            case NONE: {
                this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.borderPropertiesElement.removeAttribute(FoBorderBottomAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setTopBorder(Border border) {
        if (border == null) {
            this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthTopAttribute.ATTRIBUTE_NAME.getQName());
            this.borderPropertiesElement.removeAttribute(FoBorderTopAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:border-line-width-top", border.getDoubleLineWidthDescription());
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-top", border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-top", border.getBorderDescription());
                break;
            }
            case NONE: {
                this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthTopAttribute.ATTRIBUTE_NAME.getQName());
                this.borderPropertiesElement.removeAttribute(FoBorderTopAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setLeftBorder(Border border) {
        if (border == null) {
            this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthLeftAttribute.ATTRIBUTE_NAME.getQName());
            this.borderPropertiesElement.removeAttribute(FoBorderLeftAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:border-line-width-left", border.getDoubleLineWidthDescription());
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-left", border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-left", border.getBorderDescription());
                break;
            }
            case NONE: {
                this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.borderPropertiesElement.removeAttribute(FoBorderLeftAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setRightBorder(Border border) {
        if (border == null) {
            this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthRightAttribute.ATTRIBUTE_NAME.getQName());
            this.borderPropertiesElement.removeAttribute(FoBorderRightAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:border-line-width-right", border.getDoubleLineWidthDescription());
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-right", border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-right", border.getBorderDescription());
                break;
            }
            case NONE: {
                this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthRightAttribute.ATTRIBUTE_NAME.getQName());
                this.borderPropertiesElement.removeAttribute(FoBorderRightAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setBorder(Border border) {
        if (border == null) {
            this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthAttribute.ATTRIBUTE_NAME.getQName());
            this.borderPropertiesElement.removeAttribute(FoBorderAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:border-line-width", border.getDoubleLineWidthDescription());
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border", border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.borderPropertiesElement.setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border", border.getBorderDescription());
                break;
            }
            case NONE: {
                this.borderPropertiesElement.removeAttribute(StyleBorderLineWidthAttribute.ATTRIBUTE_NAME.getQName());
                this.borderPropertiesElement.removeAttribute(FoBorderAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public Border getBorder() {
        Border border = new Border();
        String borderAttr = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "border");
        String borderWidth = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width");
        if (borderAttr == null || borderAttr.length() == 0) {
            return null;
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public Border getTopBorder() {
        Border border = new Border();
        String borderAttr = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-top");
        String borderWidth = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-top");
        if (borderAttr == null || borderAttr.length() == 0) {
            return this.getBorder();
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public Border getLeftBorder() {
        Border border = new Border();
        String borderAttr = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-left");
        String borderWidth = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-left");
        if (borderAttr == null || borderAttr.length() == 0) {
            return this.getBorder();
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public Border getRightBorder() {
        Border border = new Border();
        String borderAttr = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-right");
        String borderWidth = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-right");
        if (borderAttr == null || borderAttr.length() == 0) {
            return this.getBorder();
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public Border getBottomBorder() {
        Border border = new Border();
        String borderAttr = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-bottom");
        String borderWidth = this.borderPropertiesElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-bottom");
        if (borderAttr == null || borderAttr.length() == 0) {
            return this.getBorder();
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }
}

