/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.components.questionreply.QuestionReplyException;
import org.silverpeas.components.questionreply.index.QuestionIndexer;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.components.questionreply.model.Recipient;
import org.silverpeas.components.questionreply.model.Reply;
import org.silverpeas.components.questionreply.service.QuestionManager;
import org.silverpeas.components.questionreply.service.QuestionRegexpComparator;
import org.silverpeas.components.questionreply.service.QuestionReplyContentManager;
import org.silverpeas.components.questionreply.service.notification.SubscriptionNotifier;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class SilverpeasQuestionManager
implements QuestionManager {
    private static final String STATUS = "status";
    private static final String INSTANCE_ID = "instanceId";
    private static final String QUESTION_ID = "questionId";
    @Inject
    private QuestionIndexer questionIndexer;
    private SilverpeasBeanDAO<Question> questionDao = null;
    private SilverpeasBeanDAO<Reply> replyDao = null;
    private SilverpeasBeanDAO<Recipient> recipientDao = null;
    @Inject
    private QuestionReplyContentManager contentManager;
    @Inject
    private OrganizationController controller;

    SilverpeasQuestionManager() {
        try {
            this.questionDao = SilverpeasBeanDAOFactory.getDAO(Question.class);
            this.replyDao = SilverpeasBeanDAOFactory.getDAO(Reply.class);
            this.recipientDao = SilverpeasBeanDAOFactory.getDAO(Recipient.class);
        }
        catch (PersistenceException ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
        }
    }

    @Override
    public long createQuestion(Question question) throws QuestionReplyException {
        long l;
        block10: {
            Connection con = DBUtil.openConnection();
            try {
                List<Recipient> recipients = question.readRecipients();
                IdPK pkQ = (IdPK)this.questionDao.add(con, (SilverpeasEntityBean)question);
                question.setPK((WAPrimaryKey)pkQ);
                this.questionIndexer.createIndex(question, Collections.emptyList());
                long idQ = pkQ.getIdAsLong();
                if (recipients != null) {
                    for (Recipient recipient : recipients) {
                        recipient.setQuestionId(idQ);
                        this.createRecipient(con, recipient);
                    }
                }
                question.setPK((WAPrimaryKey)pkQ);
                this.contentManager.createSilverContent(con, question);
                l = idQ;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | ContentManagerException | PersistenceException e) {
                    throw new QuestionReplyException(e);
                }
            }
            con.close();
        }
        return l;
    }

    @Override
    public long createReply(Reply reply, Question question) throws QuestionReplyException {
        long l;
        block9: {
            Connection con = DBUtil.openConnection();
            try {
                IdPK pkR = (IdPK)this.replyDao.add(con, (SilverpeasEntityBean)reply);
                WysiwygController.createFileAndAttachment((String)reply.readCurrentWysiwygContent(), (ResourceReference)new ResourceReference((WAPrimaryKey)pkR), (String)reply.getCreatorId(), (String)I18NHelper.DEFAULT_LANGUAGE);
                long idR = pkR.getIdAsLong();
                if (question.hasNewStatus()) {
                    question.waitForAnswer();
                }
                this.updateQuestion(con, question);
                this.questionIndexer.updateIndex(question, this.getAllReplies(reply.getQuestionId(), question.getInstanceId()));
                this.notifySubscribers(question, reply);
                l = idR;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | PersistenceException e) {
                    throw new QuestionReplyException(e);
                }
            }
            con.close();
        }
        return l;
    }

    private void createRecipient(Connection con, Recipient recipient) throws QuestionReplyException {
        try {
            this.recipientDao.add(con, (SilverpeasEntityBean)recipient);
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    private void deleteRecipients(Connection con, long questionId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)QUESTION_ID, (Object)questionId);
            this.recipientDao.removeBy(con, criteria);
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public void closeQuestions(Collection<Long> questionIds) throws QuestionReplyException {
        if (questionIds != null) {
            try (Connection con = DBUtil.openConnection();){
                for (Long idQ : questionIds) {
                    Question question = this.getQuestion(idQ);
                    question.close();
                    this.updateQuestion(con, question);
                }
            }
            catch (SQLException e) {
                throw new QuestionReplyException(e);
            }
        }
    }

    @Override
    public void openQuestions(Collection<Long> questionIds) throws QuestionReplyException {
        if (questionIds != null) {
            try (Connection con = DBUtil.openConnection();){
                for (Long idQ : questionIds) {
                    Question question = this.getQuestion(idQ);
                    question.waitForAnswer();
                    this.updateQuestion(con, question);
                }
            }
            catch (SQLException e) {
                throw new QuestionReplyException(e);
            }
        }
    }

    @Override
    public void updateQuestionRecipients(Question question) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            List<Recipient> recipients = question.readRecipients();
            this.deleteRecipients(con, ((IdPK)question.getPK()).getIdAsLong());
            if (recipients != null) {
                for (Recipient recipient : recipients) {
                    recipient.setQuestionId(((IdPK)question.getPK()).getIdAsLong());
                    this.createRecipient(con, recipient);
                }
            }
        }
        catch (SQLException | QuestionReplyException e) {
            throw new QuestionReplyException((Throwable)e);
        }
    }

    @Override
    public void updateQuestionRepliesPublicStatus(Collection<Long> questionIds) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            if (questionIds != null) {
                for (Long idQ : questionIds) {
                    Question question = this.getQuestion(idQ);
                    List<Reply> replies = this.getQuestionPublicReplies(idQ, question.getInstanceId());
                    if (replies != null) {
                        for (Reply reply : replies) {
                            reply.setPublicReply(0);
                            this.addComponentId(reply, question.getPK().getInstanceId());
                            this.updateReply(con, reply);
                        }
                        this.updateQuestion(con, question);
                    }
                    if (!question.hasNewStatus()) continue;
                    this.deleteQuestion(con, idQ);
                }
            }
        }
        catch (SQLException | QuestionReplyException e) {
            throw new QuestionReplyException((Throwable)e);
        }
    }

    @Override
    public void updateQuestionRepliesPrivateStatus(Collection<Long> questionIds) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            if (questionIds != null) {
                for (Long idQ : questionIds) {
                    Question question = this.getQuestion(idQ);
                    List<Reply> replies = this.getQuestionPrivateReplies(idQ, question.getInstanceId());
                    if (replies == null) continue;
                    for (Reply reply : replies) {
                        reply.setPrivateReply(0);
                        this.addComponentId(reply, question.getPK().getInstanceId());
                        this.updateReply(con, reply);
                    }
                    this.updateQuestion(con, question);
                }
            }
        }
        catch (SQLException | QuestionReplyException e) {
            throw new QuestionReplyException((Throwable)e);
        }
    }

    private void addComponentId(Reply reply, String componentId) {
        reply.getPK().setComponentName(componentId);
    }

    @Override
    public void updateRepliesPublicStatus(Collection<Long> replyIds, Question question) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            if (replyIds != null) {
                for (Long idR : replyIds) {
                    Reply reply = this.getReply(idR);
                    if (reply == null) continue;
                    reply.setPublicReply(0);
                    this.addComponentId(reply, question.getPK().getInstanceId());
                    this.updateReply(con, reply);
                }
                this.updateQuestion(con, question);
            }
        }
        catch (SQLException | QuestionReplyException e) {
            throw new QuestionReplyException((Throwable)e);
        }
    }

    @Override
    public void updateRepliesPrivateStatus(Collection<Long> replyIds, Question question) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            if (replyIds != null) {
                for (Long idR : replyIds) {
                    Reply reply = this.getReply(idR);
                    if (reply == null) continue;
                    reply.setPrivateReply(0);
                    this.addComponentId(reply, question.getPK().getInstanceId());
                    this.updateReply(con, reply);
                }
                this.updateQuestion(con, question);
            }
        }
        catch (SQLException | QuestionReplyException e) {
            throw new QuestionReplyException((Throwable)e);
        }
    }

    private void updateQuestion(Connection con, Question question) throws QuestionReplyException {
        try {
            long idQ = ((IdPK)question.getPK()).getIdAsLong();
            question.setReplyNumber(this.getQuestionRepliesNumber(idQ));
            question.setPublicReplyNumber(this.getQuestionPublicRepliesNumber(idQ));
            question.setPrivateReplyNumber(this.getQuestionPrivateRepliesNumber(idQ));
            if (question.getReplyNumber() == 0 && question.hasClosedStatus()) {
                this.deleteQuestion(con, idQ);
            } else {
                this.questionDao.update(con, (SilverpeasEntityBean)question);
                this.questionIndexer.updateIndex(question, this.getAllReplies(idQ, question.getInstanceId()));
                question.getPK().setComponentName(question.getInstanceId());
                this.contentManager.updateSilverContentVisibility(question);
            }
        }
        catch (Exception e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public void updateQuestion(Question question) throws QuestionReplyException {
        try {
            long idQ = ((IdPK)question.getPK()).getIdAsLong();
            question.setReplyNumber(this.getQuestionRepliesNumber(idQ));
            question.setPublicReplyNumber(this.getQuestionPublicRepliesNumber(idQ));
            question.setPrivateReplyNumber(this.getQuestionPrivateRepliesNumber(idQ));
            if (question.getReplyNumber() == 0 && question.hasClosedStatus()) {
                this.deleteQuestion(idQ);
            } else {
                this.questionDao.update((SilverpeasEntityBean)question);
                this.questionIndexer.updateIndex(question, this.getAllReplies(idQ, question.getInstanceId()));
                question.getPK().setComponentName(question.getInstanceId());
                this.contentManager.updateSilverContentVisibility(question);
            }
        }
        catch (Exception e) {
            throw new QuestionReplyException(e);
        }
    }

    private void updateReply(Connection con, Reply reply) throws QuestionReplyException {
        try {
            Question question = this.getQuestion(reply.getQuestionId());
            reply.getPK().setComponentName(question.getInstanceId());
            if (reply.getPublicReply() == 0 && reply.getPrivateReply() == 0) {
                this.deleteReply(con, reply.getPK());
            } else {
                this.replyDao.update(con, (SilverpeasEntityBean)reply);
                this.updateWysiwygContent(reply);
            }
            this.questionIndexer.updateIndex(question, this.getAllReplies(reply.getQuestionId(), question.getInstanceId()));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public void updateReply(Reply reply) throws QuestionReplyException {
        try {
            Question question = this.getQuestion(reply.getQuestionId());
            if (reply.getPublicReply() == 0 && reply.getPrivateReply() == 0) {
                this.deleteReply(((IdPK)reply.getPK()).getIdAsLong());
            } else {
                this.replyDao.update((SilverpeasEntityBean)reply);
                this.updateReplyWysiwygContent(reply);
            }
            this.questionIndexer.updateIndex(question, this.getAllReplies(reply.getQuestionId(), question.getInstanceId()));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    private void updateReplyWysiwygContent(Reply reply) {
        this.updateWysiwygContent(reply);
    }

    private void deleteQuestion(Connection con, long questionId) throws QuestionReplyException {
        try {
            this.deleteRecipients(con, questionId);
            IdPK pk = new IdPK();
            pk.setIdAsLong(questionId);
            Question question = this.getQuestion(questionId);
            String peasId = question.getInstanceId();
            this.questionDao.remove(con, (WAPrimaryKey)pk);
            this.questionIndexer.deleteIndex(question);
            pk.setComponentName(peasId);
            this.contentManager.deleteSilverContent(con, pk);
        }
        catch (Exception e) {
            throw new QuestionReplyException(e);
        }
    }

    private void deleteQuestion(long questionId) throws QuestionReplyException {
        try (Connection connection = DBUtil.openConnection();){
            this.deleteQuestion(connection, questionId);
        }
        catch (SQLException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public void deleteQuestionAndReplies(Collection<Long> questionIds) throws QuestionReplyException {
        for (Long questionId : questionIds) {
            Connection con = null;
            try {
                con = DBUtil.openConnection();
                this.deleteRecipients(con, questionId);
                IdPK pk = new IdPK();
                pk.setIdAsLong(questionId.longValue());
                Question question = this.getQuestion(questionId);
                String peasId = question.getInstanceId();
                List<Reply> replies = this.getAllReplies(questionId, peasId);
                for (Reply reply : replies) {
                    long replyId = Long.parseLong(reply.getPK().getId());
                    this.addComponentId(reply, question.getInstanceId());
                    this.deleteReply(replyId);
                }
                this.questionIndexer.deleteIndex(question);
                this.questionDao.remove(con, (WAPrimaryKey)pk);
                pk.setComponentName(peasId);
                this.contentManager.deleteSilverContent(con, pk);
            }
            catch (Exception e) {
                throw new QuestionReplyException(e);
            }
            finally {
                DBUtil.close((Connection)con);
            }
        }
    }

    @Override
    public List<Reply> getAllReplies(long questionId, String instanceId) throws QuestionReplyException {
        ArrayList<Reply> allReplies = new ArrayList<Reply>();
        try {
            List<Reply> privateReplies = this.getQuestionPrivateReplies(questionId, instanceId);
            allReplies.addAll(privateReplies);
            List<Reply> publicReplies = this.getQuestionPublicReplies(questionId, instanceId);
            allReplies.addAll(publicReplies);
            return allReplies;
        }
        catch (Exception e) {
            throw new QuestionReplyException(e);
        }
    }

    private void deleteReply(long replyId) throws QuestionReplyException {
        try (Connection con = DBUtil.openConnection();){
            IdPK pk = new IdPK();
            pk.setIdAsLong(replyId);
            this.replyDao.remove(con, (WAPrimaryKey)pk);
        }
        catch (SQLException | PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    private void deleteReply(Connection con, WAPrimaryKey replyId) throws QuestionReplyException {
        try {
            this.replyDao.remove(con, replyId);
            WysiwygController.deleteFile((String)replyId.getInstanceId(), (String)replyId.getId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public Question getQuestion(long questionId) throws QuestionReplyException {
        try {
            IdPK pk = new IdPK();
            pk.setIdAsLong(questionId);
            return (Question)this.questionDao.findByPrimaryKey((WAPrimaryKey)pk);
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public Question getQuestionAndReplies(long questionId) throws QuestionReplyException {
        try {
            IdPK pk = new IdPK();
            pk.setIdAsLong(questionId);
            Question question = (Question)this.questionDao.findByPrimaryKey((WAPrimaryKey)pk);
            List<Reply> replies = this.getQuestionReplies(questionId, question.getInstanceId());
            question.writeReplies(replies);
            return question;
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Question> getQuestionsByIds(List<String> ids) throws QuestionReplyException {
        BeanCriteria criteria = ids.isEmpty() ? BeanCriteria.emptyCriteria() : BeanCriteria.addCriterion((String)"id", (Collection)ids.stream().map(Integer::parseInt).collect(Collectors.toSet()));
        try {
            return new ArrayList<Question>(this.questionDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Reply> getQuestionReplies(long questionId, String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)QUESTION_ID, (Object)questionId);
            ArrayList<Reply> replies = new ArrayList<Reply>(this.replyDao.findBy(criteria));
            for (Reply reply : replies) {
                reply.getPK().setComponentName(instanceId);
                reply.loadWysiwygContent();
            }
            return replies;
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Reply> getQuestionPublicReplies(long questionId, String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)"publicReply", (Object)1).and(QUESTION_ID, (Object)questionId);
            ArrayList<Reply> replies = new ArrayList<Reply>(this.replyDao.findBy(criteria));
            for (Reply reply : replies) {
                reply.getPK().setComponentName(instanceId);
                reply.loadWysiwygContent();
            }
            return replies;
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Reply> getQuestionPrivateReplies(long questionId, String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)"privateReply", (Object)1).and(QUESTION_ID, (Object)questionId);
            ArrayList<Reply> replies = new ArrayList<Reply>(this.replyDao.findBy(criteria));
            for (Reply reply : replies) {
                reply.getPK().setComponentName(instanceId);
                reply.loadWysiwygContent();
            }
            return replies;
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Recipient> getQuestionRecipients(long questionId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)QUESTION_ID, (Object)questionId);
            return new ArrayList<Recipient>(this.recipientDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public Reply getReply(long replyId) throws QuestionReplyException {
        try {
            IdPK pk = new IdPK();
            pk.setIdAsLong(replyId);
            Reply reply = (Reply)this.replyDao.findByPrimaryKey((WAPrimaryKey)pk);
            if (reply != null) {
                reply.loadWysiwygContent();
            }
            return reply;
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Question> getSendQuestions(String userId, String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("creatorId", (Object)Integer.parseInt(userId)).and(BeanCriteria.addCriterion((String)STATUS, (BeanCriteria.OPERATOR)BeanCriteria.OPERATOR.NOT_EQUALS, (Object)2).or("privateReplyNumber", BeanCriteria.OPERATOR.GREATER, (Object)0));
            return new ArrayList<Question>(this.questionDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Question> getReceiveQuestions(String userId, String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and(STATUS, BeanCriteria.OPERATOR.NOT_EQUALS, (Object)2).andSubQuery("id", BeanCriteria.OPERATOR.IN, "questionId from SC_QuestionReply_Recipient", BeanCriteria.addCriterion((String)"userId", (Object)Integer.parseInt(userId)));
            return new ArrayList<Question>(this.questionDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Question> getQuestions(String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and(BeanCriteria.addCriterion((String)STATUS, (BeanCriteria.OPERATOR)BeanCriteria.OPERATOR.NOT_EQUALS, (Object)2).or("publicReplyNumber", BeanCriteria.OPERATOR.GREATER, (Object)0));
            criteria.setDescOrderBy(new String[]{"creationDate", "id"});
            return new ArrayList<Question>(this.questionDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public List<Question> getAllQuestions(String instanceId) throws QuestionReplyException {
        List<Question> allQuestions = this.getQuestions(instanceId);
        ArrayList<Question> questions = new ArrayList<Question>(allQuestions.size());
        for (Question question : allQuestions) {
            Question fullQuestion = this.getQuestionAndReplies(Long.parseLong(question.getPK().getId()));
            questions.add(fullQuestion);
        }
        if (this.isSortable(instanceId)) {
            questions.sort(QuestionRegexpComparator.getInstance());
        }
        return questions;
    }

    @Override
    public List<Question> getAllQuestionsByCategory(String instanceId, String categoryId) throws QuestionReplyException {
        List<Question> allQuestions = this.getQuestions(instanceId);
        ArrayList<Question> questions = new ArrayList<Question>(allQuestions.size());
        for (Question question : allQuestions) {
            if ((!StringUtil.isNotDefined((String)question.getCategoryId()) || !StringUtil.isNotDefined((String)categoryId)) && (!StringUtil.isDefined((String)categoryId) || !StringUtil.isDefined((String)question.getCategoryId()) || !question.getCategoryId().equals(categoryId))) continue;
            Question fullQuestion = this.getQuestionAndReplies(Long.parseLong(question.getPK().getId()));
            questions.add(fullQuestion);
        }
        if (this.isSortable(instanceId)) {
            questions.sort(QuestionRegexpComparator.getInstance());
        }
        return questions;
    }

    @Override
    public List<Question> getPublicQuestions(String instanceId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)INSTANCE_ID, (Object)instanceId).and("publicReplyNumber", BeanCriteria.OPERATOR.GREATER, (Object)0);
            criteria.setAscOrderBy(new String[]{"id"});
            return new ArrayList<Question>(this.questionDao.findBy(criteria));
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    @Override
    public long createQuestionReply(Question question, Reply reply) throws QuestionReplyException {
        long idQ;
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            IdPK pkQ = (IdPK)this.questionDao.add(con, (SilverpeasEntityBean)question);
            idQ = pkQ.getIdAsLong();
            reply.setQuestionId(idQ);
            WAPrimaryKey pkR = this.replyDao.add(con, (SilverpeasEntityBean)reply);
            reply.getPK().setId(pkR.getId());
            WysiwygController.createFileAndAttachment((String)reply.readCurrentWysiwygContent(), (ResourceReference)new ResourceReference(pkR), (String)reply.getCreatorId(), (String)I18NHelper.DEFAULT_LANGUAGE);
            this.questionIndexer.createIndex(question, Collections.singletonList(reply));
            Question updatedQuestion = this.getQuestion(idQ);
            this.contentManager.createSilverContent(con, updatedQuestion);
            this.notifySubscribers(question, reply);
        }
        catch (Exception e) {
            throw new QuestionReplyException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return idQ;
    }

    private int getQuestionRepliesNumber(long questionId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)QUESTION_ID, (Object)questionId);
            Collection replies = this.replyDao.findBy(criteria);
            return replies.size();
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    private int getQuestionPublicRepliesNumber(long questionId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)"publicReply", (Object)1).and(QUESTION_ID, (Object)questionId);
            Collection replies = this.replyDao.findBy(criteria);
            return replies.size();
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    private int getQuestionPrivateRepliesNumber(long questionId) throws QuestionReplyException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)"privateReply", (Object)1).and(QUESTION_ID, (Object)questionId);
            Collection replies = this.replyDao.findBy(criteria);
            return replies.size();
        }
        catch (PersistenceException e) {
            throw new QuestionReplyException(e);
        }
    }

    protected void updateWysiwygContent(Reply reply) {
        if (WysiwygController.haveGotWysiwyg((String)reply.getPK().getInstanceId(), (String)reply.getPK().getId(), (String)I18NHelper.DEFAULT_LANGUAGE)) {
            WysiwygController.updateFileAndAttachment((String)reply.readCurrentWysiwygContent(), (String)reply.getPK().getInstanceId(), (String)reply.getPK().getId(), (String)reply.getCreatorId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        } else {
            WysiwygController.createUnindexedFileAndAttachment((String)reply.readCurrentWysiwygContent(), (ResourceReference)new ResourceReference(reply.getPK()), (String)reply.getCreatorId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        }
    }

    protected boolean isSortable(String instanceId) {
        return StringUtil.getBooleanValue((String)this.controller.getComponentParameterValue(instanceId, "sortable"));
    }

    private void notifySubscribers(Question question, Reply reply) {
        if (reply.getPublicReply() == 1) {
            UserDetail sender = reply.readAuthor();
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new SubscriptionNotifier((User)sender, question, reply));
        }
    }
}

