/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.model;

import java.util.Date;
import org.silverpeas.components.blog.model.Category;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.util.URLUtil;

public final class PostDetail
implements SilverpeasContent,
WithPermanentLink {
    private static final long serialVersionUID = -1703768097976820443L;
    private String content;
    private PublicationDetail publication;
    private Category category;
    private String categoryId;
    private int nbComments;
    private String creatorName;
    private Date dateEvent;
    private static final String TYPE = "Publication";

    public PostDetail(PublicationDetail publication, String categoryId) {
        this.setPublication(publication);
        this.setCategoryId(categoryId);
    }

    public PostDetail(PublicationDetail publication, String categoryId, Date dateEvent) {
        this.setPublication(publication);
        this.setCategoryId(categoryId);
        this.setDateEvent(dateEvent);
    }

    public PostDetail(PublicationDetail publication, Category category, int nbComments) {
        this.setPublication(publication);
        this.setCategory(category);
        this.setNbComments(nbComments);
    }

    public PostDetail(PublicationDetail publication, Category category, int nbComments, Date dateEvent) {
        this.setPublication(publication);
        this.setCategory(category);
        this.setNbComments(nbComments);
        this.setDateEvent(dateEvent);
    }

    public String getContent() {
        if (this.content == null) {
            this.content = WysiwygController.load((String)this.getPublication().getPK().getComponentName(), (String)this.getPublication().getPK().getId(), (String)this.getPublication().getLanguage());
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public int getNbComments() {
        return this.nbComments;
    }

    public void setNbComments(int nbComments) {
        this.nbComments = nbComments;
    }

    public PublicationDetail getPublication() {
        return this.publication;
    }

    public void setPublication(PublicationDetail publication) {
        this.publication = publication;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Date getDateEvent() {
        return this.dateEvent;
    }

    public void setDateEvent(Date dateEvent) {
        this.dateEvent = dateEvent;
    }

    public String getPermalink() {
        if (URLUtil.displayUniversalLinks()) {
            return URLUtil.getApplicationURL() + "/Post/" + this.publication.getPK().getId();
        }
        return null;
    }

    public String getId() {
        return this.publication.getId();
    }

    public String getComponentInstanceId() {
        return this.publication.getPK().getInstanceId();
    }

    public User getCreator() {
        return this.publication.getCreator();
    }

    public Date getCreationDate() {
        return this.publication.getCreationDate();
    }

    public User getLastUpdater() {
        return this.publication.getLastUpdater();
    }

    public Date getLastUpdateDate() {
        return this.publication.getLastUpdateDate();
    }

    public String getTitle() {
        return this.publication.getTitle();
    }

    public String getDescription() {
        return this.publication.getDescription();
    }

    public String getContributionType() {
        return PostDetail.getResourceType();
    }

    public static String getResourceType() {
        return TYPE;
    }

    public String getSilverpeasContentId() {
        return this.publication.getSilverpeasContentId();
    }
}

