/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.net.ssl.SSLSocketFactory;

abstract class AbstractTLSClientAuthentication
extends ClientAuthentication {
    private final SSLSocketFactory sslSocketFactory;

    protected AbstractTLSClientAuthentication(ClientAuthenticationMethod method, ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(method, clientID);
        this.sslSocketFactory = sslSocketFactory;
    }

    protected AbstractTLSClientAuthentication(ClientAuthenticationMethod method, ClientID clientID) {
        super(method, clientID);
        this.sslSocketFactory = null;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public void applyTo(HTTPRequest httpRequest) {
        if (httpRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType ct = httpRequest.getContentType();
        if (ct == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!ct.match(CommonContentTypes.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + CommonContentTypes.APPLICATION_URLENCODED);
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        params.put("client_id", this.getClientID().getValue());
        String queryString = URLUtils.serializeParameters(params);
        httpRequest.setQuery(queryString);
        httpRequest.setSSLSocketFactory(this.sslSocketFactory);
    }
}

