/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.saml2;

import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetails;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import net.jcip.annotations.ThreadSafe;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.impl.AssertionMarshaller;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class SAML2AssertionFactory {
    public static Assertion create(SAML2AssertionDetails details, String xmlDsigAlg, Credential credential) {
        Assertion a = details.toSAML2Assertion();
        Signature signature = (Signature)Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(credential);
        signature.setSignatureAlgorithm(xmlDsigAlg);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        a.setSignature(signature);
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        try {
            marshallerFactory.getMarshaller((XMLObject)a).marshall((XMLObject)a);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException | SignatureException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        return a;
    }

    public static Element createAsElement(SAML2AssertionDetails details, String xmlDsigAlg, Credential credential) {
        Assertion a = SAML2AssertionFactory.create(details, xmlDsigAlg, credential);
        AssertionMarshaller assertionMarshaller = new AssertionMarshaller();
        try {
            return assertionMarshaller.marshall((XMLObject)a);
        }
        catch (MarshallingException e) {
            throw new SerializeException(e.getMessage(), e);
        }
    }

    public static String createAsString(SAML2AssertionDetails details, String xmlDsigAlg, Credential credential) {
        Element a = SAML2AssertionFactory.createAsElement(details, xmlDsigAlg, credential);
        String xml = XMLHelper.nodeToString((Node)a);
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        return xml.substring("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length());
    }

    public static String createAsString(SAML2AssertionDetails details, RSAPrivateKey rsaPrivateKey) {
        BasicCredential credential = new BasicCredential();
        credential.setPrivateKey((PrivateKey)rsaPrivateKey);
        credential.setUsageType(UsageType.SIGNING);
        return SAML2AssertionFactory.createAsString(details, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Credential)credential);
    }

    private SAML2AssertionFactory() {
    }
}

