/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.AbstractTLSClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.Immutable;

@Immutable
public class SelfSignedTLSClientAuthentication
extends AbstractTLSClientAuthentication {
    private final X509Certificate x509Certificate;

    public SelfSignedTLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID, sslSocketFactory);
        this.x509Certificate = null;
    }

    public SelfSignedTLSClientAuthentication(ClientID clientID, X509Certificate x509Certificate) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID);
        if (x509Certificate == null) {
            throw new IllegalArgumentException("The client X.509 certificate must not be null");
        }
        this.x509Certificate = x509Certificate;
    }

    public X509Certificate getClientX509Certificate() {
        return this.x509Certificate;
    }

    public static SelfSignedTLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        String clientIDString = params.get("client_id");
        if (StringUtils.isBlank(clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        X509Certificate cert = httpRequest.getClientX509Certificate();
        if (cert == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new SelfSignedTLSClientAuthentication(new ClientID(clientIDString), cert);
    }
}

