/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

class HandlerUtil {
    HandlerUtil() {
    }

    static void writeFromInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        InputStream inputStream2 = inputStream;
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        while ((n = inputStream2.read()) >= 0) {
            outputStream.write(n);
        }
        inputStream2.close();
    }

    static void writeFromBarrInputStreamSMIMESTreamProcessor(Object object, OutputStream outputStream) throws IOException {
        if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof InputStream) {
            HandlerUtil.writeFromInputStream((InputStream)object, outputStream);
        } else if (object instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor sMIMEStreamingProcessor = (SMIMEStreamingProcessor)object;
            sMIMEStreamingProcessor.write(outputStream);
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }

    static void writeFromMimeBodyPart(MimeBodyPart mimeBodyPart, OutputStream outputStream) throws IOException {
        try {
            mimeBodyPart.writeTo(outputStream);
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
    }

    static Object getTransferData(DataContentHandler dataContentHandler, ActivationDataFlavor activationDataFlavor, DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (activationDataFlavor.equals(dataFlavor)) {
            return dataContentHandler.getContent(dataSource);
        }
        return null;
    }
}

