/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.IntTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetCounts
extends IntTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    public TaxonomyFacetCounts(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, config);
        this.ordinalsReader = ordinalsReader;
        this.count(fc.getMatchingDocs());
    }

    private final void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        IntsRef scratch = new IntsRef();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
            DocIdSetIterator docs = hits.bits.iterator();
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                ords.get(doc, scratch);
                for (int i = 0; i < scratch.length; ++i) {
                    int n = scratch.ints[scratch.offset + i];
                    this.values[n] = this.values[n] + 1;
                }
            }
        }
        this.rollup();
    }
}

