/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.notification.user;

import java.util.Collection;
import java.util.Collections;
import org.owasp.encoder.Encode;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.notification.user.AbstractGalleryUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.kernel.util.StringUtil;

public class GalleryUserAlertNotification
extends AbstractGalleryUserNotification<Media> {
    private final NodePK nodePK;
    private final User sender;

    public GalleryUserAlertNotification(NodePK nodePK, Media resource, User sender) {
        super(resource);
        this.nodePK = nodePK;
        this.sender = sender;
    }

    protected String getTemplateFileName() {
        return "manualUserNotification";
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "gallery.notifLinkLabel";
    }

    protected void perform(Media resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected void performTemplateData(String language, Media resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, StringUtil.defaultStringIfNotDefined((String)this.getTitle(language), (String)this.getTitle()), "");
        template.setAttribute("senderName", (Object)this.sender.getDisplayedName());
        template.setAttribute("mediaTitle", (Object)Encode.forHtml((String)resource.getTitle()));
        template.setAttribute("path", (Object)this.getPath(language));
    }

    protected void performNotificationResource(String language, Media resource, NotificationResourceData notificationResourceData) {
    }

    protected String getComponentInstanceId() {
        return ((Media)this.getResource()).getInstanceId();
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.emptyList();
    }

    protected boolean stopWhenNoUserToNotify() {
        return false;
    }

    private String getPath(String language) {
        return WebEncodeHelper.javaStringToHtmlString((String)NodeService.get().getPath(this.nodePK).format(language));
    }
}

