/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.components.gallery.GalleryComponentSettings;
import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.components.gallery.constant.MediaMimeType;
import org.silverpeas.components.gallery.delegate.MediaDataCreateDelegate;
import org.silverpeas.components.gallery.delegate.MediaDataUpdateDelegate;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.components.gallery.process.media.GalleryCreateMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryCreateMediaFileProcess;
import org.silverpeas.components.gallery.process.media.GalleryDeindexMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryDeleteMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryDeleteMediaFileProcess;
import org.silverpeas.components.gallery.process.media.GalleryIndexMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryPasteMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryPasteMediaFileProcess;
import org.silverpeas.components.gallery.process.media.GalleryUpdateMediaDataProcess;
import org.silverpeas.components.gallery.process.media.GalleryUpdateMediaFileProcess;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.process.ProcessProvider;
import org.silverpeas.core.process.SilverpeasProcess;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.util.ProcessList;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

public class GalleryProcessManagement {
    private static final String UNKNOWN = "unknown";
    private final UserDetail user;
    private final String componentInstanceId;
    private final ProcessList<ProcessExecutionContext> processList;

    public GalleryProcessManagement(UserDetail user, String componentInstanceId) {
        this.user = user;
        this.componentInstanceId = componentInstanceId;
        this.processList = new ProcessList();
    }

    public void execute() {
        Transaction.performInOne(() -> {
            try {
                ProcessProvider.getProcessManagement().execute(this.processList, new ProcessExecutionContext(this.user, this.componentInstanceId));
                return null;
            }
            catch (Exception e) {
                throw new GalleryRuntimeException(e);
            }
        });
    }

    public void addCreateMediaProcesses(Media media, String albumId, Object file, Watermark watermark, MediaDataCreateDelegate delegate) {
        this.processList.add((SilverpeasProcess)GalleryCreateMediaDataProcess.getInstance(media, albumId, delegate));
        this.processList.add((SilverpeasProcess)GalleryCreateMediaFileProcess.getInstance(media, file, watermark));
        this.processList.add((SilverpeasProcess)GalleryUpdateMediaDataProcess.getInstance(media));
        this.processList.add((SilverpeasProcess)GalleryIndexMediaDataProcess.getInstance(media));
    }

    public void addUpdateMediaProcesses(Media media, Watermark watermark, MediaDataUpdateDelegate delegate) {
        this.processList.add((SilverpeasProcess)GalleryUpdateMediaDataProcess.getInstance(media, delegate));
        FileItem fileItem = delegate.getFileItem();
        if (fileItem != null && StringUtil.isDefined((String)fileItem.getName())) {
            this.processList.add((SilverpeasProcess)GalleryUpdateMediaFileProcess.getInstance(media, fileItem, watermark));
            this.processList.add((SilverpeasProcess)GalleryUpdateMediaDataProcess.getInstance(media));
        }
        this.processList.add((SilverpeasProcess)GalleryIndexMediaDataProcess.getInstance(media));
    }

    public void addIndexMediaProcesses(Media media) {
        this.processList.add((SilverpeasProcess)GalleryIndexMediaDataProcess.getInstance(media));
    }

    public void addDeleteMediaProcesses(Media media) {
        this.processList.add((SilverpeasProcess)GalleryDeleteMediaDataProcess.getInstance(media));
        this.processList.add((SilverpeasProcess)GalleryDeleteMediaFileProcess.getInstance(media));
        this.processList.add((SilverpeasProcess)GalleryDeindexMediaDataProcess.getInstance(media));
    }

    public void addPasteMediaProcesses(Media mediaToPaste, NodePK toAlbum, boolean isCut) {
        MediaPK fromMediaPk = new MediaPK(mediaToPaste.getId(), mediaToPaste.getInstanceId());
        this.processList.add((SilverpeasProcess)GalleryPasteMediaDataProcess.getInstance(mediaToPaste, toAlbum.getId(), fromMediaPk, isCut));
        this.processList.add((SilverpeasProcess)GalleryPasteMediaFileProcess.getInstance(mediaToPaste, fromMediaPk, isCut));
        if (isCut) {
            this.processList.add((SilverpeasProcess)GalleryDeindexMediaDataProcess.getInstance(mediaToPaste));
            this.processList.add((SilverpeasProcess)GalleryIndexMediaDataProcess.getInstance(mediaToPaste));
        }
    }

    public static void importFromRepositoryProcesses(UserDetail user, String componentInstanceId, File repository, String albumId, MediaDataCreateDelegate delegate) {
        Watermark watermark = GalleryComponentSettings.getWatermark(componentInstanceId);
        File[] fileList = repository.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isFile()) {
                    MediaMimeType mediaMimeType = MediaMimeType.fromFile(file);
                    Media newMedia = GalleryProcessManagement.getMediaByType(mediaMimeType);
                    if (newMedia == null) continue;
                    GalleryProcessManagement processManagement = new GalleryProcessManagement(user, componentInstanceId);
                    processManagement.addCreateMediaProcesses(newMedia, albumId, file, watermark, delegate);
                    processManagement.execute();
                    continue;
                }
                if (!file.isDirectory()) continue;
                AlbumDetail newAlbum = GalleryProcessManagement.createAlbum(user, componentInstanceId, file.getName(), albumId);
                GalleryProcessManagement.importFromRepositoryProcesses(user, componentInstanceId, file, newAlbum.getNodePK().getId(), delegate);
            }
        }
    }

    private static Media getMediaByType(MediaMimeType mediaMimeType) {
        InternalMedia newMedia = mediaMimeType.isSupportedPhotoType() ? new Photo() : (mediaMimeType.isSupportedVideoType() ? new Video() : (mediaMimeType.isSupportedSoundType() ? new Sound() : null));
        return newMedia;
    }

    private static AlbumDetail createAlbum(UserDetail user, String componentInstanceId, String name, String albumId) {
        AlbumDetail newAlbum = new AlbumDetail(new NodeDetail(UNKNOWN, name, null, 0, UNKNOWN));
        newAlbum.setCreationDate(new Date());
        newAlbum.setCreatorId(user.getId());
        newAlbum.getNodePK().setComponentName(componentInstanceId);
        return GalleryProcessManagement.getGalleryService().createAlbum(newAlbum, new NodePK(albumId, componentInstanceId));
    }

    public void addPasteAlbumProcesses(AlbumDetail fromAlbum, AlbumDetail toAlbum, boolean isCut) {
        boolean pasteAllowed;
        boolean bl = pasteAllowed = !fromAlbum.equals((Object)toAlbum) && !fromAlbum.isFatherOf(toAlbum);
        if (!pasteAllowed) {
            return;
        }
        if (isCut) {
            for (NodeDetail subAlbumToPaste : GalleryProcessManagement.getNodeService().getSubTree(fromAlbum.getNodePK())) {
                NodePK toSubAlbumPK = new NodePK(subAlbumToPaste.getNodePK().getId(), this.componentInstanceId);
                this.addPasteMediaAlbumProcesses(subAlbumToPaste.getNodePK(), toSubAlbumPK, true);
            }
            GalleryProcessManagement.getNodeService().moveNode(fromAlbum.getNodePK(), toAlbum.getNodePK());
        } else {
            AlbumDetail newAlbum = new AlbumDetail(new NodeDetail());
            NodePK newAlbumPK = new NodePK(UNKNOWN, this.componentInstanceId);
            newAlbum.setNodePK(newAlbumPK);
            newAlbum.setCreatorId(this.user.getId());
            newAlbum.setName(fromAlbum.getName());
            newAlbum.setDescription(fromAlbum.getDescription());
            newAlbum.setTranslations(fromAlbum.getTranslations());
            newAlbum.setCreationDate(fromAlbum.getCreationDate());
            newAlbum.setRightsDependsOn(toAlbum.getRightsDependsOn());
            GalleryProcessManagement.getNodeService().createNode((NodeDetail)newAlbum, (NodeDetail)toAlbum);
            this.addPasteMediaAlbumProcesses(fromAlbum.getNodePK(), newAlbum.getNodePK(), false);
            for (NodeDetail subNode : GalleryProcessManagement.getNodeService().getChildrenDetails(fromAlbum.getNodePK())) {
                this.addPasteAlbumProcesses(new AlbumDetail(subNode), newAlbum, false);
            }
        }
    }

    private void addPasteMediaAlbumProcesses(NodePK fromAlbumPk, NodePK toAlbumPk, boolean isCut) {
        for (Media media : GalleryProcessManagement.getGalleryService().getAllMedia(fromAlbumPk, MediaCriteria.VISIBILITY.FORCE_GET_ALL)) {
            this.addPasteMediaProcesses(media, toAlbumPk, isCut);
        }
    }

    public void addDeleteAlbumProcesses(NodePK albumPk) {
        this.addDeleteMediaAlbumProcesses(albumPk);
        Collection children = GalleryProcessManagement.getNodeService().getChildrenDetails(albumPk);
        for (NodeDetail node : children) {
            this.addDeleteAlbumProcesses(node.getNodePK());
        }
        GalleryProcessManagement.getNodeService().removeNode(albumPk);
    }

    private void addDeleteMediaAlbumProcesses(NodePK albumPk) {
        for (Media media : GalleryProcessManagement.getGalleryService().getAllMedia(albumPk, MediaCriteria.VISIBILITY.FORCE_GET_ALL)) {
            Collection<String> albumIds = GalleryProcessManagement.getGalleryService().getAlbumIdsOf(media);
            if (albumIds.size() > 1) {
                albumIds.remove(albumPk.getId());
                media.setToAlbums(albumIds.toArray(new String[0]));
                continue;
            }
            this.addDeleteMediaProcesses(media);
        }
    }

    private static GalleryService getGalleryService() {
        return (GalleryService)ServiceProvider.getService(GalleryService.class, (Annotation[])new Annotation[0]);
    }

    private static NodeService getNodeService() {
        return NodeService.get();
    }
}

