/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.dao;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

public class PhotoDAO {
    private PhotoDAO() {
    }

    public static Photo getPhoto(String photoId) throws SQLException {
        Photo photo = PhotoDAO.getByCriteria(MediaCriteria.fromMediaId(photoId));
        if (photo == null) {
            photo = new Photo();
        }
        return photo;
    }

    public static Collection<Photo> getAllPhoto(String albumId, String instanceId, MediaCriteria.VISIBILITY visibility) throws SQLException {
        return PhotoDAO.findByCriteria(MediaCriteria.fromComponentInstanceId(instanceId).albumIdentifierIsOneOf(albumId).withVisibility(visibility));
    }

    private static Photo getByCriteria(MediaCriteria criteria) throws SQLException {
        return (Photo)JdbcSqlQuery.unique(PhotoDAO.findByCriteria(criteria.withVisibility(MediaCriteria.VISIBILITY.FORCE_GET_ALL)));
    }

    private static List<Photo> findByCriteria(MediaCriteria criteria) throws SQLException {
        criteria.mediaTypeIsOneOf(MediaType.Photo);
        return MediaDAO.findByCriteria(criteria).stream().map(Media::getPhoto).collect(Collectors.toList());
    }
}

