/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;

@Provider
@Named(value="galleryStatistics")
public class GalleryStatistics
implements ComponentStatisticsProvider {
    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        Collection<Media> media = this.getGalleryService().getAllMedia(componentId, MediaCriteria.VISIBILITY.FORCE_GET_ALL);
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>(media.size());
        for (Media aMedia : media) {
            UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
            myCouple.setUserId(aMedia.getCreatorId());
            myCouple.setCountVolume(1L);
            myArrayList.add(myCouple);
        }
        return myArrayList;
    }

    public long memorySizeOfSpecificFiles(String componentId) {
        GalleryFileSizeCounter fileSizeCounter = new GalleryFileSizeCounter();
        long result = 0L;
        try {
            Files.walkFileTree(Paths.get(FileRepositoryManager.getAbsolutePath((String)componentId), new String[0]), fileSizeCounter);
            result = fileSizeCounter.getSize();
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return result;
    }

    public long countSpecificFiles(String componentId) {
        GalleryFileCounter fileCounter = new GalleryFileCounter();
        long result = 0L;
        try {
            Files.walkFileTree(Paths.get(FileRepositoryManager.getAbsolutePath((String)componentId), new String[0]), fileCounter);
            result = fileCounter.getCount();
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return result;
    }

    private GalleryService getGalleryService() {
        return (GalleryService)ServiceProvider.getService(GalleryService.class, (Annotation[])new Annotation[0]);
    }

    private static abstract class GallerySpecificFileVisitor
    implements FileVisitor<Path> {
        private static final String PHOTO_PREFIX = MediaType.Photo.getTechnicalFolder();
        private static final String VIDEO_PREFIX = MediaType.Video.getTechnicalFolder();
        private static final String SOUND_PREFIX = MediaType.Sound.getTechnicalFolder();
        private boolean firstAccess = true;
        private final FileVisitResult preVisitDirectoryResult;

        GallerySpecificFileVisitor(boolean visitFiles) {
            this.preVisitDirectoryResult = visitFiles ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public final FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            FileVisitResult result = this.preVisitDirectoryResult;
            if (this.isSpecificDirectory(dir)) {
                this.handleDirectory(dir, attrs);
            } else if (!this.firstAccess) {
                result = FileVisitResult.SKIP_SUBTREE;
            }
            if (this.firstAccess) {
                this.firstAccess = false;
                return FileVisitResult.CONTINUE;
            }
            return result;
        }

        private boolean isSpecificDirectory(Path dir) {
            String fileName = dir.getFileName().toString();
            return fileName.startsWith(PHOTO_PREFIX) || fileName.startsWith(VIDEO_PREFIX) || fileName.startsWith(SOUND_PREFIX);
        }

        @Override
        public final FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.handleFile(file, attrs);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult visitFileFailed(Path file, IOException exc) {
            SilverLogger.getLogger((Object)this).warn((Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public final FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        protected abstract void handleDirectory(Path var1, BasicFileAttributes var2);

        protected abstract void handleFile(Path var1, BasicFileAttributes var2);
    }

    private class GalleryFileSizeCounter
    extends GallerySpecificFileVisitor {
        private long size;

        private GalleryFileSizeCounter() {
            super(true);
            this.size = 0L;
        }

        @Override
        protected void handleDirectory(Path file, BasicFileAttributes attrs) {
        }

        @Override
        protected void handleFile(Path file, BasicFileAttributes attrs) {
            this.size += attrs.size();
        }

        long getSize() {
            return this.size;
        }
    }

    private class GalleryFileCounter
    extends GallerySpecificFileVisitor {
        private long count;

        private GalleryFileCounter() {
            super(false);
            this.count = 0L;
        }

        @Override
        protected void handleDirectory(Path file, BasicFileAttributes attrs) {
            ++this.count;
        }

        @Override
        protected void handleFile(Path file, BasicFileAttributes attrs) {
        }

        long getCount() {
            return this.count;
        }
    }
}

